/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.datapruner.DataPruner;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.sla.AuxHelper;
import org.miloss.fgsms.sla.SLACommon;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class DataPrunerScheduler
implements StatefulJob {
    private static Logger log = Logger.getLogger((String)"fgsms.DataPruner");

    public void DataPrunerScheduler() {
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        log.log((Priority)Level.INFO, (Object)"========================================================== Data Pruner Job executing...");
        try {
            AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:DataPruner:" + SLACommon.GetHostName()), (String)"OK", (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
            Long lastranat = null;
            try {
                lastranat = (Long)jec.getJobDetail().getJobDataMap().get((Object)"lastranat");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lastranat == null) {
                lastranat = 0L;
            }
            KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"DataPruner", (String)"Interval");
            long intinterval = 86400000L;
            if (interval != null) {
                try {
                    intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                    if (intinterval < 30000L) {
                        intinterval = 30000L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lastranat + intinterval < System.currentTimeMillis()) {
                DataPruner m = new DataPruner();
                m.Purge(true);
                jec.getJobDetail().getJobDataMap().put("lastranat", System.currentTimeMillis());
            }
        }
        catch (Exception ex) {
            AuxHelper.TryUpdateStatus((boolean)false, (String)("urn:fgsms:DataPruner:" + SLACommon.GetHostName()), (String)ex.getMessage(), (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
            log.log((Priority)Level.WARN, (Object)"error caught", (Throwable)ex);
        }
    }
}

