/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.DependencyScannerScheduler;
import org.miloss.fgsms.common.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class DependencyScannerStarter
implements ServletContextListener {
    public static final String JOB_NAME = "DependencyScanner";
    public static final String TRIGGER_NAME = "DependencyScannerTrigger";
    private static Scheduler sc;
    static Logger log;

    public void contextInitialized(ServletContextEvent sce) {
    }

    protected static void StartupCheck() {
        JobDetail job = null;
        Trigger triger = null;
        try {
            sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            if (!AuxConstants.QuartzJobExists((String)JOB_NAME, (Scheduler)sc)) {
                job = new JobDetail(JOB_NAME, "fgsms Aux Services", DependencyScannerScheduler.class);
                triger = TriggerUtils.makeMinutelyTrigger((int)1);
                triger.setStartTime(new Date());
                triger.setName(TRIGGER_NAME);
                triger.setGroup("fgsmsAuxServicesTriggers");
                job.setRequestsRecovery(true);
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)"DependencyScanner added");
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                }
                sc.start();
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)"error scheduling ", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

