/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.federation.FederationInterface;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.dataaccessservice.QuickStatData;
import org.miloss.fgsms.services.interfaces.dataaccessservice.QuickStatWrapper;
import org.miloss.fgsms.services.interfaces.policyconfiguration.FederationPolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.sla.AuxHelper;
import org.miloss.fgsms.sla.SLACommon;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class FederationScheduler
implements StatefulJob {
    private static Logger log = Logger.getLogger((String)"fgsms.FederationScheduler");

    public void UddiScheduler() {
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        KeyNameValueEnc enabled = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"FederationScheduler", (String)"Enabled");
        if (enabled == null || enabled.getKeyNameValue() == null || enabled.getKeyNameValue().getPropertyValue() == null || enabled.getKeyNameValue().getPropertyValue().equalsIgnoreCase("false")) {
            AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:FederationScheduler:" + SLACommon.GetHostName()), (String)"Disabled", (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
            return;
        }
        AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:FederationScheduler:" + SLACommon.GetHostName()), (String)"OK", (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
        KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"FederationScheduler", (String)"Interval");
        long intinterval = 3600000L;
        if (interval != null) {
            try {
                intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                if (intinterval < 300000L) {
                    intinterval = 300000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Long lastranat = null;
        try {
            lastranat = (Long)jec.getJobDetail().getJobDataMap().get((Object)"lastranat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lastranat == null) {
            lastranat = 0L;
        }
        if (lastranat + intinterval < System.currentTimeMillis()) {
            log.log((Priority)Level.INFO, (Object)"========================================================== Federation Job executing...");
            try {
                List LoadFederationServicePoliciesPooled = SLACommon.LoadFederationServicePoliciesPooled();
                for (int i = 0; i < LoadFederationServicePoliciesPooled.size(); ++i) {
                    if (((ServicePolicy)LoadFederationServicePoliciesPooled.get(i)).getFederationPolicyCollection() != null) {
                        for (int k = 0; k < ((ServicePolicy)LoadFederationServicePoliciesPooled.get(i)).getFederationPolicyCollection().getFederationPolicy().size(); ++k) {
                            String clazz = ((FederationPolicy)((ServicePolicy)LoadFederationServicePoliciesPooled.get(i)).getFederationPolicyCollection().getFederationPolicy().get(k)).getImplementingClassName();
                            FederationInterface newInstance = null;
                            try {
                                Class<?> forName = Class.forName(clazz);
                                newInstance = (FederationInterface)forName.newInstance();
                                if (newInstance == null) continue;
                                newInstance.Publish(true, this.getQuickStatData(((ServicePolicy)LoadFederationServicePoliciesPooled.get(i)).getURL(), true), (ServicePolicy)LoadFederationServicePoliciesPooled.get(i), (FederationPolicy)((ServicePolicy)LoadFederationServicePoliciesPooled.get(i)).getFederationPolicyCollection().getFederationPolicy().get(k));
                                continue;
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.FATAL, (Object)("unable to load federation plugin! classname=" + clazz), (Throwable)ex);
                            }
                        }
                    }
                    AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:FederationScheduler:" + SLACommon.GetHostName()), (String)"OK", (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"error caught from uddi publisher", (Throwable)ex);
                AuxHelper.TryUpdateStatus((boolean)false, (String)("urn:fgsms:FederationScheduler:" + SLACommon.GetHostName()), (String)ex.getMessage(), (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
            }
            jec.getJobDetail().getJobDataMap().put("lastranat", System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QuickStatWrapper getQuickStatData(String urL, boolean pooled) {
        QuickStatWrapper quickStatWrapper;
        PreparedStatement com = null;
        if (Utility.stringIsNullOrEmpty((String)urL)) {
            return null;
        }
        Connection con = null;
        ResultSet rs = null;
        try {
            con = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
            com = con.prepareStatement("select * from agg2 where uri=? and soapaction=?;");
            com.setString(1, urL);
            com.setString(2, "All-Methods");
            rs = com.executeQuery();
            QuickStatWrapper w = new QuickStatWrapper();
            w.setAction("All-Methods");
            DatatypeFactory df = DatatypeFactory.newInstance();
            while (rs.next()) {
                QuickStatData d = new QuickStatData();
                long timerange = rs.getLong("timerange");
                d.setTimeInMinutes(BigInteger.valueOf(timerange / 60000L));
                d.setAvailabilityPercentage(rs.getDouble("avail"));
                d.setFailureCount(rs.getLong("failure"));
                d.setSuccessCount(rs.getLong("success"));
                d.setSLAViolationCount(rs.getLong("sla"));
                d.setAverageResponseTime(rs.getLong("avgres"));
                if (rs.getLong("mtbf") == -1L) {
                    d.setMTBF(null);
                } else {
                    d.setMTBF(df.newDuration(rs.getLong("mtbf")));
                }
                d.setMaximumRequestSize(rs.getLong("maxreq"));
                d.setMaximumResponseSize(rs.getLong("maxres"));
                d.setMaximumResponseTime(rs.getLong("maxresponsetime"));
                GregorianCalendar gcal = new GregorianCalendar();
                gcal.setTimeInMillis(rs.getLong("timestampepoch"));
                d.setUpdatedAt((Calendar)gcal);
                w.getQuickStatData().add(d);
            }
            w.setUptime(this.getUpTime(urL));
            rs.close();
            com.close();
            con.close();
            quickStatWrapper = w;
        }
        catch (Exception ex) {
            try {
                log.log((Priority)Level.WARN, (Object)("can't get statistics for " + urL), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return null;
        }
        DBUtils.safeClose((ResultSet)rs);
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return quickStatWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Duration getUpTime(String uri) {
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block8: {
            Duration duration;
            block7: {
                con = null;
                com = null;
                rs = null;
                try {
                    con = Utility.getPerformanceDBConnection();
                    com = con.prepareStatement("select * from availability where uri=? order by utcdatetime desc limit 1");
                    com.setString(1, uri);
                    Duration d = null;
                    rs = com.executeQuery();
                    if (rs.next()) {
                        long changeat = rs.getLong("utcdatetime");
                        long now = System.currentTimeMillis();
                        DatatypeFactory f = DatatypeFactory.newInstance();
                        d = f.newDuration(now - changeat);
                    }
                    if (d != null) {
                        duration = d;
                        DBUtils.safeClose((ResultSet)rs);
                        break block7;
                    }
                    DBUtils.safeClose((ResultSet)rs);
                    break block8;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, null, (Throwable)ex);
                    return null;
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return duration;
        }
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return null;
        finally {
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
        }
    }
}

