/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.FederationScheduler;
import org.miloss.fgsms.common.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class FederationStarter
implements ServletContextListener {
    private static Scheduler sc;
    static final Logger log;
    public static final String JOB_NAME = "Federation Publisher";
    public static final String TRIGGER_NAME = "Federation Publisher Trigger";

    public void contextInitialized(ServletContextEvent sce) {
    }

    protected static void StartupCheck() {
        try {
            sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            if (sc == null) {
                log.fatal((Object)"Unable to reference the Quartz instance of fgsmsAuxServicesQuartzScheduler ensure that it exists and is started. Unable to schedule job for Federation Publisher");
            }
            JobDetail job = null;
            Trigger triger = null;
            if (!AuxConstants.QuartzJobExists((String)JOB_NAME, (Scheduler)sc)) {
                job = new JobDetail(JOB_NAME, "fgsms Aux Services", FederationScheduler.class);
                triger = TriggerUtils.makeMinutelyTrigger((int)2);
                triger.setName(TRIGGER_NAME);
                triger.setGroup("fgsmsAuxServicesTriggers");
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)"Federation Publisher job added");
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                }
                sc.start();
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)"error scheduling Federation Publisher", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

