/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.agents.HornetqJMSAgent;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.IpAddressUtility;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.sla.AuxHelper;
import org.miloss.fgsms.sla.SLACommon;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class HornetQScheduler
implements StatefulJob {
    private static Logger log = Logger.getLogger((String)"fgsms.Agents");

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:HornetqAgent:" + SLACommon.GetHostName()), (String)"OK", (boolean)true, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)SLACommon.GetHostName());
        try {
            KeyNameValueEnc item = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"HornetQAgent", (String)"URLs");
            String t = null;
            String[] urls = null;
            try {
                if (item != null) {
                    t = item.getKeyNameValue().getPropertyValue();
                    urls = t.split("\\|");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    String connecturl = urls[i];
                    String modifiedurl = IpAddressUtility.modifyURL((String)connecturl, (boolean)true);
                    HornetqJMSAgent.Fire((boolean)true, (String)connecturl, (String)modifiedurl);
                }
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)"Could not start the HornetQAgent ", (Throwable)ex);
        }
        KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"HornetQAgent", (String)"Interval");
        long intinterval = 30000L;
        if (interval != null) {
            try {
                intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                if (intinterval < 1000L) {
                    intinterval = 1000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

