/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.HornetQScheduler;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HornetQStarter
implements ServletContextListener {
    private static Scheduler sc;
    static Logger log;
    public static final String JOB_NAME = "HornetQAgent";
    public static final String TRIGGER_NAME = "HornetQAgent Trigger";

    public void contextInitialized(ServletContextEvent sce) {
        HornetQStarter.StartupCheck();
    }

    protected static void StartupCheck() {
        block10: {
            try {
                JobDetail job = null;
                Trigger triger = null;
                sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
                if (sc == null) {
                    log.fatal((Object)"Unable to reference the Quartz instance of fgsmsAuxServicesQuartzScheduler ensure that it exists and is started. Unable to schedule job for HornetQAgent");
                }
                KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"HornetQAgent", (String)"Interval");
                long intinterval = 30000L;
                if (interval != null) {
                    try {
                        intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                        if (intinterval < 1000L) {
                            intinterval = 1000L;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (AuxConstants.QuartzJobExists((String)"HornetQAgent", (Scheduler)sc)) break block10;
                job = new JobDetail("HornetQAgent", "fgsms Aux Services", HornetQScheduler.class);
                job.setRequestsRecovery(true);
                try {
                    triger = TriggerUtils.makeSecondlyTrigger((int)((int)(intinterval / 1000L)));
                    triger.setStartTime(new Date());
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, (Object)("the configuration parameter for HornetQAgent Iinterval is " + intinterval + " and could not be parsed as an integer. Defaulting to 30 second pings"));
                    triger = TriggerUtils.makeSecondlyTrigger((int)30);
                }
                triger.setName("HornetQAgent Trigger");
                triger.setGroup("fgsmsAuxServicesTriggers");
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)"HornetQAgent added");
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                }
                sc.start();
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)"error scheduling HornetQAgent", (Throwable)ex);
            }
        }
    }

    protected static void Unschedule() {
        try {
            Scheduler sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            sc.deleteJob("HornetQAgent", "fgsms Aux Services");
        }
        catch (Exception ex) {
            log.log((Priority)Level.DEBUG, (Object)"Error removing job for HornetQAgent", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

