/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.NTSLAProcessorScheduler;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class NTSLAStarter
implements ServletContextListener {
    public static final String JOB_NAME = "NTSLA";
    public static final String TRIGGER_NAME = "NTSLA Trigger";
    private static Scheduler sc;
    static Logger log;

    public void contextInitialized(ServletContextEvent sce) {
    }

    protected static void StartupCheck() {
        try {
            KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"NTSLAProcessor", (String)"Interval");
            long intinterval = 10000L;
            if (interval != null) {
                try {
                    intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                    if (intinterval < 1000L) {
                        intinterval = 1000L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler")) == null) {
                log.fatal((Object)"Unable to reference the Quartz instance of fgsmsAuxServicesQuartzScheduler ensure that it exists and is started. Unable to schedule job for NTSLA");
            }
            JobDetail job = null;
            Trigger triger = null;
            if (!AuxConstants.QuartzJobExists((String)JOB_NAME, (Scheduler)sc)) {
                job = new JobDetail(JOB_NAME, "fgsms Aux Services", NTSLAProcessorScheduler.class);
                job.setRequestsRecovery(true);
                triger = TriggerUtils.makeSecondlyTrigger((int)((int)intinterval / 1000));
                triger.setName(TRIGGER_NAME);
                triger.setGroup("fgsmsAuxServicesTriggers");
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)("NTSLA job added at interval " + intinterval));
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                }
                sc.start();
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)"error scheduling ntsla", (Throwable)ex);
        }
    }

    protected static void Unschedule() {
        try {
            Scheduler sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            sc.deleteJob(JOB_NAME, "fgsms Aux Services");
        }
        catch (Exception ex) {
            log.log((Priority)Level.DEBUG, (Object)"Error removing job for NTSLA", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

