/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.StatisticsAggregatorScheduler;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatisticsStarter
implements ServletContextListener {
    public static final String JOB_NAME = "Statistics Aggregator";
    public static final String TRIGGER_NAME = "Stat Agg Trigger";
    private static Scheduler sc;
    static Logger log;

    public void contextInitialized(ServletContextEvent sce) {
        StatisticsStarter.StartupCheck();
    }

    protected static void StartupCheck() {
        try {
            JobDetail job = null;
            Trigger triger = null;
            sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            if (sc == null) {
                log.fatal((Object)"Unable to reference the Quartz instance of fgsmsAuxServicesQuartzScheduler ensure that it exists and is started. Unable to schedule job for Statistics Aggregator");
            }
            KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"StatisticsAggregator", (String)"Interval");
            long intinterval = 300000L;
            if (interval != null) {
                try {
                    intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                    if (intinterval < 1000L) {
                        intinterval = 300000L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!AuxConstants.QuartzJobExists((String)"Statistics Aggregator", (Scheduler)sc)) {
                job = new JobDetail("Statistics Aggregator", "fgsms Aux Services", StatisticsAggregatorScheduler.class);
                triger = TriggerUtils.makeSecondlyTrigger((int)((int)intinterval / 1000));
                triger.setStartTime(new Date());
                triger.setName("Stat Agg Trigger");
                triger.setGroup("fgsmsAuxServicesTriggers");
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)("Stats Agg job added at interval " + intinterval));
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                }
                sc.start();
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)"error scheduling statistics agg", (Throwable)ex);
        }
    }

    protected static void Unschedule() {
        try {
            Scheduler sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            sc.deleteJob("Statistics Aggregator", "fgsms Aux Services");
        }
        catch (Exception ex) {
            log.log((Priority)Level.DEBUG, (Object)"Error removing job for Statistics Aggregator", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

