/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.reporting;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.GregorianCalendar;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.AuditLogger;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ReportDefinition;

public class ReportFetch
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = null;
        if (request.getUserPrincipal() != null) {
            user = request.getUserPrincipal().getName();
        }
        if (user == null) {
            user = "anonymouse";
        }
        String reportid = request.getParameter("reportid");
        ServletOutputStream out = response.getOutputStream();
        Connection con = Utility.getPerformanceDBConnection();
        PreparedStatement cmd = null;
        ResultSet rs = null;
        try {
            if (Utility.stringIsNullOrEmpty((String)user)) {
                response.sendError(401, "Authorization Required");
            } else if (Utility.stringIsNullOrEmpty((String)user)) {
                response.sendError(400, "Bad request, a report id is required");
            } else {
                cmd = con.prepareStatement("select hasextrapermissions, reportdef, owninguser, reportcontents, arsjobs.jobid as JOB from arsjobs, arsreports where arsjobs.jobid=arsreports.jobid and  arsreports.reportid=? ");
                cmd.setString(1, reportid);
                rs = cmd.executeQuery();
                if (rs.next()) {
                    boolean accessCheck = false;
                    boolean accesscontrolrules = rs.getBoolean("hasextrapermissions");
                    if (user.equalsIgnoreCase(rs.getString("owninguser"))) {
                        accessCheck = true;
                    }
                    if (accesscontrolrules) {
                        ReportDefinition def = null;
                        JAXBContext GetARSSerializationContext = Utility.getARSSerializationContext();
                        Unmarshaller u = GetARSSerializationContext.createUnmarshaller();
                        byte[] s = rs.getBytes("reportdef");
                        ByteArrayInputStream bss = new ByteArrayInputStream(s);
                        XMLInputFactory xf = XMLInputFactory.newInstance();
                        XMLStreamReader r = xf.createXMLStreamReader(bss);
                        JAXBElement foo = u.unmarshal(r, ReportDefinition.class);
                        if (foo != null && foo.getValue() != null) {
                            def = (ReportDefinition)foo.getValue();
                        }
                        if (def != null) {
                            for (int i = 0; i < def.getAdditionalReaders().size(); ++i) {
                                if (!((String)def.getAdditionalReaders().get(i)).equalsIgnoreCase(user)) continue;
                                accessCheck = true;
                            }
                        }
                    }
                    if (accessCheck) {
                        AuditLogger.logItem((String)"ServletReportFetcher", (String)"GET (access a stored report)", (String)user, (String)("Report id " + reportid + " Job id " + rs.getString("JOB")), (String)"unspecified", null);
                        response.setHeader("contentType", "application/zip");
                        response.setHeader("Cache-Control", "no-cache");
                        response.setHeader("Content-disposition", "attachment; filename=\"report" + GregorianCalendar.getInstance().get(1) + (GregorianCalendar.getInstance().get(2) + 1) + GregorianCalendar.getInstance().get(5) + "-" + reportid + ".zip\"");
                        response.setStatus(200);
                        response.setCharacterEncoding("UTF-8");
                        byte[] buffer = new byte[1024];
                        InputStream binaryStream = rs.getBinaryStream("reportcontents");
                        int x = binaryStream.read(buffer);
                        while (x > 0) {
                            out.write(buffer, 0, x);
                            x = binaryStream.read(buffer);
                        }
                        binaryStream.close();
                    } else {
                        AuditLogger.logItem((String)"ServletReportFetcher", (String)"GET (access a stored report)", (String)user, (String)("ACCESS DENIED Report id " + reportid + " Job id " + rs.getString("JOB")), (String)"unspecified", null);
                        response.sendError(403, "Access Denied");
                    }
                } else {
                    response.sendError(404, "Report Not Found");
                }
                rs.close();
                cmd.close();
            }
            con.close();
        }
        catch (Exception ex) {
            try {
                Logger.getLogger((String)"report fetcher").log((Priority)Level.FATAL, null, (Throwable)ex);
                AuditLogger.logItem((String)"ServletReportFetcher", (String)"GET (access a stored report)", (String)user, (String)("ERROR Report id " + reportid + " " + ex.getMessage()), (String)"unspecified", null);
                response.sendError(500);
            }
            catch (Throwable throwable) {
                out.close();
                DBUtils.safeClose(rs);
                DBUtils.safeClose(cmd);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            out.close();
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)cmd);
            DBUtils.safeClose((Connection)con);
        }
        out.close();
        DBUtils.safeClose(rs);
        DBUtils.safeClose((PreparedStatement)cmd);
        DBUtils.safeClose((Connection)con);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "fgsms Report Fetcher";
    }
}

