/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.renderers.DocumentRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageExporter {
    private static final List<String> SUPPORTED_FORMATS = Arrays.asList("bmp", "png", "jpg", "jpeg");
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageExporter.class);

    public static String export(String format, MapDocument mapDocument, String outputPath) {
        if (!SUPPORTED_FORMATS.contains(format.toLowerCase())) {
            LOGGER.error("The format '" + format + "' is not supported. Currently supported formats : " + String.join((CharSequence)", ", SUPPORTED_FORMATS));
            return null;
        }
        File output = new File(outputPath);
        try {
            ImageIO.write((RenderedImage)DocumentRenderer.render(mapDocument), format, output);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write the map document to the file '" + outputPath + "'");
        }
        return outputPath;
    }

    public static String export(MapDocument mapDocument, String outputPath) {
        String ext = outputPath.substring(outputPath.lastIndexOf(".") + 1).toLowerCase();
        return ImageExporter.export(ext, mapDocument, outputPath);
    }

    public static List<String> getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }
}

