/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes;

import java.util.List;
import java.util.regex.Pattern;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.utils.PageSize;
import org.millipixel.marettes.utils.Unit;

public class MapDocument {
    private final int width;
    private final int height;
    private String back = null;
    public List<Element> elements;

    public MapDocument(int width, int height, List<Element> elements) {
        this.width = width;
        this.height = height;
        this.elements = elements;
    }

    public MapDocument(PageSize size, List<Element> elements) {
        this.width = (int)Unit.convert(size.getW(), size.getUnit(), Unit.PX);
        this.height = (int)Unit.convert(size.getH(), size.getUnit(), Unit.PX);
        this.elements = elements;
    }

    public String getBack() {
        return this.back;
    }

    public void setBack(String back) {
        if (Pattern.compile("#[0-9ABCDEF]{6}").matcher(back).find()) {
            this.back = back;
        }
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDpi() {
        return 96;
    }
}

