/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.elements;

import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.millipixel.marettes.elements.Element;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapElement
extends Element {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapElement.class);
    private final List<Layer> layers;
    private final String title;
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final String crs;

    public MapElement(int x, int y, int width, int height, List<Layer> layers, String title, double xMin, double xMax, double yMin, double yMax, String crs) {
        super(x, y, width, height);
        this.layers = layers;
        this.title = title;
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.crs = crs;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public MapContent toMapContent() {
        MapContent mc = new MapContent();
        mc.addLayers(this.getLayers());
        mc.setTitle(this.title);
        CoordinateReferenceSystem decodedCrs = null;
        try {
            decodedCrs = CRS.decode((String)this.crs);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to decode the CRS '" + this.crs + "'", (Throwable)e);
        }
        mc.setViewport(new MapViewport(new ReferencedEnvelope(this.xMin, this.xMax, this.yMin, this.yMax, decodedCrs)));
        return mc;
    }

    public String getTitle() {
        return this.title;
    }

    public double getxMin() {
        return this.xMin;
    }

    public double getxMax() {
        return this.xMax;
    }

    public double getyMin() {
        return this.yMin;
    }

    public double getyMax() {
        return this.yMax;
    }

    public String getCrs() {
        return this.crs;
    }
}

