/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.styling.SLDParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.MapElement;
import org.millipixel.marettes.parsers.CompassParser;
import org.millipixel.marettes.parsers.FrameParser;
import org.millipixel.marettes.parsers.LegendParser;
import org.millipixel.marettes.parsers.Parser;
import org.millipixel.marettes.parsers.ScaleParser;
import org.millipixel.marettes.parsers.TextParser;
import org.millipixel.marettes.utils.PageSize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDocumentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapDocumentParser.class);
    private static final List<Parser> parsers = new ArrayList<Parser>();

    public static MapDocument parseResource(String resPath, Class<?> clazz) {
        return MapDocumentParser.parse(clazz.getResourceAsStream(resPath), clazz);
    }

    public static MapDocument parse(String path) {
        try {
            return MapDocumentParser.parse(new FileInputStream(path), null);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to open the file '" + path + "'");
            return null;
        }
    }

    private static MapDocument parse(InputStream inputStream, @Nullable Class<?> loader) {
        MapDocument mapDocument;
        JSONObject obj;
        JSONParser parser = new JSONParser();
        try {
            obj = (JSONObject)parser.parse((Reader)new InputStreamReader(inputStream));
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Unable to parse input stream. PLease ensure the file exists and is accessible", e);
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        if (obj.containsKey((Object)"w") && obj.containsKey((Object)"h")) {
            mapDocument = new MapDocument(((Long)obj.get((Object)"w")).intValue(), ((Long)obj.get((Object)"h")).intValue(), elements);
        } else if (obj.containsKey((Object)"size")) {
            mapDocument = new MapDocument(PageSize.valueOf((String)obj.get((Object)"size")), elements);
        } else {
            LOGGER.error("Please set w/h or size value.");
            return null;
        }
        String back = (String)obj.get((Object)"back");
        if (back != null) {
            mapDocument.setBack(back);
        }
        JSONArray body = (JSONArray)obj.get((Object)"body");
        for (Object o : body) {
            JSONObject e = (JSONObject)o;
            for (Parser p : parsers) {
                if (!p.isValid(e.get((Object)"type"))) continue;
                elements.add(p.parse(e));
            }
            if (!e.get((Object)"type").equals("map")) continue;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            elements.add(new MapElement(((Long)e.get((Object)"x")).intValue(), ((Long)e.get((Object)"y")).intValue(), ((Long)e.get((Object)"w")).intValue(), ((Long)e.get((Object)"h")).intValue(), layers, (String)e.get((Object)"name"), (Double)e.get((Object)"xmin"), (Double)e.get((Object)"xmax"), (Double)e.get((Object)"ymin"), (Double)e.get((Object)"ymax"), (String)e.get((Object)"crs")));
            JSONArray layerArr = (JSONArray)e.get((Object)"layers");
            for (Object o1 : layerArr) {
                SimpleFeatureSource source;
                String typeName;
                DataStore dataStore;
                JSONObject l = (JSONObject)o1;
                HashMap<String, URL> map = new HashMap<String, URL>();
                if (loader != null) {
                    map.put("url", loader.getResource((String)l.get((Object)"data")));
                } else {
                    try {
                        map.put("url", new File((String)l.get((Object)"data")).toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.error("Unable to open the file '" + l.get((Object)"data") + "'");
                        continue;
                    }
                }
                try {
                    dataStore = DataStoreFinder.getDataStore(map);
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to get the datastore '" + map.get("url").toString() + "'");
                    return mapDocument;
                }
                try {
                    typeName = dataStore.getTypeNames()[0];
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to get the type name of the datastore '" + map.get("url").toString() + "'");
                    return mapDocument;
                }
                try {
                    source = dataStore.getFeatureSource(typeName);
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to get the feature source from the datastore '" + map.get("url").toString() + "'");
                    return mapDocument;
                }
                StyleFactory styleFactory3 = CommonFactoryFinder.getStyleFactory();
                SLDParser styleReader = new SLDParser(styleFactory3, loader.getResourceAsStream((String)l.get((Object)"style")));
                Style style = styleReader.readXML()[0];
                layers.add((Layer)new FeatureLayer((FeatureSource)source, style, (String)l.get((Object)"name")));
            }
        }
        return mapDocument;
    }

    static {
        parsers.addAll(Arrays.asList(new CompassParser(), new FrameParser(), new LegendParser(), new ScaleParser(), new TextParser()));
    }
}

