/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import com.twelvemonkeys.image.ResampleOp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.millipixel.marettes.ImageExporter;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.CompassElement;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.renderers.G2DRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompassRenderer
implements G2DRenderer<CompassElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompassRenderer.class);

    @Override
    public void render(CompassElement compass, Graphics2D g2d, MapDocument doc) {
        BufferedImage img;
        String style = "assets/north/style" + compass.getStyle() + ".svg";
        InputStream styleStream = ImageExporter.class.getResourceAsStream(style);
        if (styleStream == null) {
            LOGGER.error("Unable to open the file '" + style + "'");
            return;
        }
        try {
            img = ImageIO.read(styleStream);
        }
        catch (IOException e) {
            LOGGER.error("Unable to read the image '" + style + "'", (Throwable)e);
            return;
        }
        if (compass.getR() != 0.0) {
            double sin = Math.abs(Math.sin(compass.getR()));
            double cos = Math.abs(Math.cos(compass.getR()));
            int w = img.getWidth();
            int h = img.getHeight();
            int newW = (int)Math.floor((double)w * cos + (double)h * sin);
            int newH = (int)Math.floor((double)h * cos + (double)w * sin);
            BufferedImage rot = new BufferedImage(newW, newH, img.getType());
            Graphics2D g2dRot = rot.createGraphics();
            AffineTransform at = new AffineTransform();
            at.translate(((double)newW - (double)w) / 2.0, ((double)newH - (double)h) / 2.0);
            int x = w / 2;
            int y = h / 2;
            at.rotate(compass.getR(), x, y);
            g2dRot.setTransform(at);
            g2dRot.drawImage((Image)img, 0, 0, null);
            g2dRot.dispose();
            img = rot;
        }
        ResampleOp resampler = new ResampleOp(compass.getWidth(), compass.getHeight(), 13);
        BufferedImage output = resampler.filter(img, null);
        g2d.drawImage(output, compass.getX(), compass.getY(), output.getWidth(), output.getHeight(), null);
    }

    @Override
    public boolean isValid(Element e) {
        return e.getClass().equals(CompassElement.class);
    }
}

