/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.MapElement;
import org.millipixel.marettes.renderers.CompassRenderer;
import org.millipixel.marettes.renderers.FrameRenderer;
import org.millipixel.marettes.renderers.G2DRenderer;
import org.millipixel.marettes.renderers.LegendRenderer;
import org.millipixel.marettes.renderers.ScaleRenderer;
import org.millipixel.marettes.renderers.TextRenderer;

public class DocumentRenderer {
    private static final List<G2DRenderer> g2dRenderers = new ArrayList<G2DRenderer>();

    public static BufferedImage render(MapDocument mapDocument) {
        BufferedImage bi = new BufferedImage(mapDocument.getWidth(), mapDocument.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        if (mapDocument.getBack() != null) {
            g2d.setPaint(Color.decode(mapDocument.getBack()));
            g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        }
        HashMap<String, ReferencedEnvelope> mapContentMap = new HashMap<String, ReferencedEnvelope>();
        HashMap<String, MapElement> mapElementMap = new HashMap<String, MapElement>();
        for (Element element : mapDocument.getElements()) {
            G2DRenderer renderer2;
            for (G2DRenderer renderer2 : g2dRenderers) {
                if (!renderer2.isValid(element)) continue;
                renderer2.render(element, g2d, mapDocument);
            }
            if (!(element instanceof MapElement)) continue;
            MapElement me = (MapElement)element;
            mapElementMap.put(me.getTitle(), me);
            renderer2 = new StreamingRenderer();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderer2.setJava2DHints(hints);
            MapContent mc = me.toMapContent();
            renderer2.setMapContent(mc);
            ReferencedEnvelope mapBounds = new ReferencedEnvelope(me.getxMin(), me.getxMax(), me.getyMin(), me.getyMax(), mc.getCoordinateReferenceSystem());
            mapContentMap.put(me.getTitle(), mapBounds);
            Rectangle imageBounds = new Rectangle(me.getX(), me.getY(), me.getWidth(), me.getHeight());
            renderer2.paint(g2d, imageBounds, mapBounds);
            g2d.dispose();
            g2d = bi.createGraphics();
            g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        return bi;
    }

    static {
        g2dRenderers.addAll(Arrays.asList(new CompassRenderer(), new FrameRenderer(), new LegendRenderer(), new ScaleRenderer(), new TextRenderer()));
    }
}

