/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.FrameElement;
import org.millipixel.marettes.renderers.G2DRenderer;

public class FrameRenderer
implements G2DRenderer<FrameElement> {
    @Override
    public void render(FrameElement frame, Graphics2D g2d, MapDocument doc) {
        if (frame.getFill() != null) {
            g2d.setColor(Color.decode(frame.getFill()));
            g2d.fillRect(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight());
        }
        if (frame.getStoke() == null) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(Color.decode(frame.getStoke()));
        Stroke old = g2d.getStroke();
        int x = frame.getX();
        int y = frame.getY();
        int w = frame.getWidth();
        int h = frame.getHeight();
        float s = frame.getSize();
        switch (frame.getStyle()) {
            case NONE: {
                break;
            }
            case DOTTED: {
                g2d.setStroke(new BasicStroke(s, 1, 0, 10.0f, new float[]{s / 4.0f, s * 2.0f}, 0.0f));
                g2d.drawRect(x, y, w, h);
                break;
            }
            case DASHED: {
                g2d.setStroke(new BasicStroke(s, 2, 0, 10.0f, new float[]{s * 2.0f, s * 3.0f}, 0.0f));
                g2d.drawRect(x, y, w, h);
                break;
            }
            case SOLID: {
                g2d.setStroke(new BasicStroke(s));
                g2d.drawRect(x, y, w, h);
                break;
            }
            case DOUBLE: {
                g2d.setStroke(new BasicStroke(s));
                g2d.drawRect(x, y, w, h);
                g2d.drawRect((int)((double)x + (double)s * 1.5), (int)((double)y + (double)s * 1.5), (int)((float)w - s * 3.0f), (int)((float)h - s * 3.0f));
                break;
            }
            case GROOVE: {
                this.drawBorderSet(Color.decode(frame.getStoke()).darker().darker(), Color.decode(frame.getStoke()).brighter().brighter(), g2d, x, y, w, h, s);
                this.drawBorderSet(Color.decode(frame.getStoke()).brighter().brighter(), Color.decode(frame.getStoke()).darker().darker(), g2d, (int)((float)x + s / 2.0f), (int)((float)y + s / 2.0f), (int)((float)w - s), (int)((float)h - s), s / 2.0f);
                break;
            }
            case RIDGE: {
                this.drawBorderSet(Color.decode(frame.getStoke()).brighter().brighter(), Color.decode(frame.getStoke()).darker().darker(), g2d, x, y, w, h, s);
                this.drawBorderSet(Color.decode(frame.getStoke()).darker().darker(), Color.decode(frame.getStoke()).brighter().brighter(), g2d, (int)((float)x + s / 2.0f), (int)((float)y + s / 2.0f), (int)((float)w - s), (int)((float)h - s), s / 2.0f);
                break;
            }
            case INSET: {
                this.drawBorderSet(Color.decode(frame.getStoke()).darker().darker(), Color.decode(frame.getStoke()).brighter().brighter(), g2d, x, y, w, h, s);
                break;
            }
            case OUTSET: {
                this.drawBorderSet(Color.decode(frame.getStoke()).brighter().brighter(), Color.decode(frame.getStoke()).darker().darker(), g2d, x, y, w, h, s);
            }
        }
        g2d.setStroke(old);
    }

    private void drawBorderSet(Color topLeft, Color botRight, Graphics2D g2d, int x, int y, int w, int h, float s) {
        g2d.setStroke(new BasicStroke(s));
        g2d.setColor(topLeft);
        g2d.drawLine(x, y, x + w, y);
        g2d.drawLine(x, y, x, y + h);
        g2d.setColor(botRight);
        g2d.drawLine(x + w, y, x + w, y + h);
        g2d.drawLine(x, y + h, x + w, y + h);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(topLeft);
        int i = 0;
        while ((float)i < s) {
            g2d.drawLine(Math.round((float)x - s / 2.0f), Math.round((float)(y + h) + s / 2.0f - 1.0f) - i, Math.round((float)x + s / 2.0f - 1.0f), Math.round((float)(y + h) - s / 2.0f));
            g2d.drawLine(Math.round((float)(x + w) - s / 2.0f), Math.round((float)y + s / 2.0f - 1.0f) - i, Math.round((float)(x + w) + s / 2.0f - 1.0f), Math.round((float)y - s / 2.0f));
            ++i;
        }
    }

    @Override
    public boolean isValid(Element e) {
        return e.getClass().equals(FrameElement.class);
    }
}

