/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.LegendElement;
import org.millipixel.marettes.elements.MapElement;
import org.millipixel.marettes.renderers.G2DRenderer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendRenderer
implements G2DRenderer<LegendElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendRenderer.class);
    private static final RenderingHints HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static SimpleFeatureType POINT_TYPE = null;
    private static SimpleFeatureType LINE_TYPE = null;
    private static SimpleFeatureType POLYGON_TYPE = null;
    private static final GeometryFactory FACTORY;
    private static final Point POINT_GEOM;
    private static final LineString LINE_GEOM;
    private static final Polygon POLYGON_GEOM;
    private static final Rectangle2D POINT_ENV_BOUNDS;
    private static final Rectangle2D LINE_ENV_BOUNDS;
    private static final Rectangle2D POLYGON_ENV_BOUNDS;

    @Override
    public boolean isValid(Element e) {
        return e.getClass().equals(LegendElement.class);
    }

    @Override
    public void render(LegendElement legend, Graphics2D g2d, MapDocument doc) {
        MapElement map = null;
        for (Element element : doc.getElements()) {
            if (!(element instanceof MapElement) || !((MapElement)element).getTitle().equals(legend.getMap())) continue;
            map = (MapElement)element;
        }
        if (map == null) {
            return;
        }
        g2d.setFont(legend.toFont());
        int h = g2d.getFontMetrics().getHeight();
        int i = 1;
        if (legend.getTitle() != null && !legend.getTitle().isEmpty()) {
            g2d.setColor(Color.BLACK);
            g2d.drawString(LegendRenderer.camel(legend.getTitle()), legend.getX(), legend.getY() + h * i);
            ++i;
        }
        for (Layer l : map.getLayers()) {
            if (l.getTitle() != null && !l.getTitle().isEmpty()) {
                g2d.drawString(LegendRenderer.camel(l.getTitle()), legend.getX(), legend.getY() + h * i);
                ++i;
            }
            for (FeatureTypeStyle fts : l.getStyle().featureTypeStyles()) {
                List rules = ((FeatureTypeStyle)((FeatureTypeStyleImpl)fts).clone()).rules();
                for (Rule rule : rules) {
                    List<Symbolizer> polySym;
                    List<Symbolizer> lineSym;
                    List<Symbolizer> ptSym = this.filter(rule, PointSymbolizer.class);
                    if (!ptSym.isEmpty()) {
                        this.drawPoint(g2d, legend.getX(), legend.getY() + h * i, ptSym, LegendRenderer.camel(rule.getName()));
                        ++i;
                    }
                    if (!(lineSym = this.filter(rule, LineSymbolizer.class)).isEmpty()) {
                        this.drawLine(g2d, legend.getX(), legend.getY() + h * i, lineSym, LegendRenderer.camel(rule.getName()));
                        ++i;
                    }
                    if ((polySym = this.filter(rule, PolygonSymbolizer.class)).isEmpty()) continue;
                    this.drawPolygon(g2d, legend.getX(), legend.getY() + h * i, polySym, LegendRenderer.camel(rule.getName()));
                    ++i;
                }
            }
            ++i;
        }
    }

    private List<Symbolizer> filter(Rule rule, Class<? extends Symbolizer> symClass) {
        return rule.symbolizers().stream().filter(sym -> symClass.isAssignableFrom(sym.getClass())).map(symbolizer -> symbolizer).collect(Collectors.toList());
    }

    private void drawPoint(Graphics2D g2d, int x, int y, List<Symbolizer> symbolizers, String name) {
        int s = g2d.getFontMetrics().getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString(name, x + 5 + s + 5, y + 2);
        MapContent mc = new MapContent();
        GTRenderer renderer = this.getRenderer(POINT_TYPE, (Geometry)POINT_GEOM, symbolizers, mc);
        Rectangle imageBounds = new Rectangle(0, 0, s, s);
        ReferencedEnvelope env = new ReferencedEnvelope(POINT_ENV_BOUNDS, mc.getMaxBounds().getCoordinateReferenceSystem());
        BufferedImage bi = new BufferedImage(s, s, 2);
        renderer.paint(bi.createGraphics(), imageBounds, env);
        g2d.drawImage((Image)bi, x, (int)((double)y - (double)s / 1.5), null);
        mc.dispose();
    }

    private void drawLine(Graphics2D g2d, int x, int y, List<Symbolizer> symbolizers, String name) {
        int s = g2d.getFontMetrics().getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString(name, x + 5 + s + 5, y);
        MapContent mc = new MapContent();
        GTRenderer renderer = this.getRenderer(LINE_TYPE, (Geometry)LINE_GEOM, symbolizers, mc);
        Rectangle imageBounds = new Rectangle(0, 0, s, s);
        ReferencedEnvelope env = new ReferencedEnvelope(LINE_ENV_BOUNDS, mc.getMaxBounds().getCoordinateReferenceSystem());
        BufferedImage bi = new BufferedImage(s, s, 2);
        renderer.paint(bi.createGraphics(), imageBounds, env);
        g2d.drawImage((Image)bi, x, (int)((double)y - (double)s / 1.5), null);
        mc.dispose();
    }

    private void drawPolygon(Graphics2D g2d, int x, int y, List<Symbolizer> symbolizers, String name) {
        int s = g2d.getFontMetrics().getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString(name, x + 5 + s + 5, y + 2);
        MapContent mc = new MapContent();
        GTRenderer renderer = this.getRenderer(POLYGON_TYPE, (Geometry)POLYGON_GEOM, symbolizers, mc);
        Rectangle imageBounds = new Rectangle(0, 0, s, s);
        ReferencedEnvelope env = new ReferencedEnvelope(POLYGON_ENV_BOUNDS, mc.getMaxBounds().getCoordinateReferenceSystem());
        BufferedImage bi = new BufferedImage(s, s, 2);
        renderer.paint(bi.createGraphics(), imageBounds, env);
        g2d.drawImage((Image)bi, x, (int)((double)y - (double)s / 1.5), null);
        mc.dispose();
    }

    private GTRenderer getRenderer(SimpleFeatureType type, Geometry geom, List<Symbolizer> symbolizers, MapContent mc) {
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        featureBuilder.add((Object)geom);
        SimpleFeatureCollection features = DataUtilities.collection((SimpleFeature)featureBuilder.buildFeature(null));
        StyleBuilder builder = new StyleBuilder();
        Style style = builder.createStyle();
        style.featureTypeStyles().add(builder.createFeatureTypeStyle(null, symbolizers.toArray(new Symbolizer[0])));
        mc.addLayers(Arrays.asList(new FeatureLayer((FeatureCollection)features, style)));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(HINTS);
        renderer.setMapContent(mc);
        return renderer;
    }

    private static String camel(String text) {
        ArrayList<CallSite> camel = new ArrayList<CallSite>();
        for (String s : text.split(" ")) {
            camel.add((CallSite)((Object)(s.substring(0, 1).toUpperCase() + s.substring(1))));
        }
        return String.join((CharSequence)" ", camel);
    }

    static {
        try {
            POINT_TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:Point:srid=4326");
        }
        catch (SchemaException e) {
            LOGGER.error("Unable to create Point SimpleFeatureType", (Throwable)e);
        }
        try {
            LINE_TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:LineString:srid=4326");
        }
        catch (SchemaException e) {
            LOGGER.error("Unable to create LineString SimpleFeatureType", (Throwable)e);
        }
        try {
            POLYGON_TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:Polygon:srid=4326");
        }
        catch (SchemaException e) {
            LOGGER.error("Unable to create Polygon SimpleFeatureType", (Throwable)e);
        }
        FACTORY = new GeometryFactory();
        POINT_GEOM = FACTORY.createPoint(new Coordinate(0.0, 0.0));
        LINE_GEOM = FACTORY.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(2.0, 0.0), new Coordinate(3.0, 1.0)});
        POLYGON_GEOM = FACTORY.createPolygon(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)});
        POINT_ENV_BOUNDS = new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
        LINE_ENV_BOUNDS = new Rectangle2D.Double(-0.5, -0.5, 3.5, 1.5);
        POLYGON_ENV_BOUNDS = new Rectangle2D.Double(-0.1, -0.1, 1.1, 1.1);
    }
}

