/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.RendererUtilities;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.MapElement;
import org.millipixel.marettes.elements.ScaleElement;
import org.millipixel.marettes.renderers.G2DRenderer;

public class ScaleRenderer
implements G2DRenderer<ScaleElement> {
    @Override
    public void render(ScaleElement scale, Graphics2D g2d, MapDocument doc) {
        MapElement map = null;
        for (Element element : doc.getElements()) {
            if (!(element instanceof MapElement) || !((MapElement)element).getTitle().equals(scale.getMap())) continue;
            map = (MapElement)element;
        }
        if (map == null) {
            return;
        }
        MapContent mc = map.toMapContent();
        HashMap<String, Integer> hints = new HashMap<String, Integer>();
        hints.put("dps", doc.getDpi());
        double ogcScale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mc.getMaxBounds(), (int)map.getWidth(), hints);
        double pxMRatio = RendererUtilities.calculatePixelsPerMeterRatio((double)ogcScale, hints);
        double scaleWM = (double)scale.getWidth() / pxMRatio;
        String unit = scaleWM > 10000.0 ? "kilometer" : "meter";
        int i = 0;
        for (scaleWM = scaleWM > 10000.0 ? scaleWM / 1000.0 : scaleWM; scaleWM > 100.0; scaleWM /= 10.0) {
            ++i;
        }
        scaleWM = (int)scaleWM;
        double h = (double)scale.getHeight() / 3.0;
        int w = (int)((scaleWM *= Math.pow(10.0, i)) * pxMRatio * (double)(unit.equals("meter") ? 1 : 1000));
        int x = scale.getX();
        int y = scale.getY();
        if (scale.getStyle().equalsIgnoreCase("bar1")) {
            this.drawStyleBar1(g2d, x, y, w, h);
        } else if (scale.getStyle().equalsIgnoreCase("bar2")) {
            this.drawStyleBar2(g2d, x, y, w, h);
        } else if (scale.getStyle().equalsIgnoreCase("line1")) {
            this.drawStyleLine1(g2d, x, y, w, h);
        } else if (scale.getStyle().equalsIgnoreCase("line2")) {
            this.drawStyleLine2(g2d, x, y, w, h);
        }
        g2d.setColor(Color.BLACK);
        g2d.setFont(g2d.getFont().deriveFont(0.6f * (float)h));
        int dx = 0;
        Object str = "0";
        g2d.drawString((String)str, dx + x, (int)(0.6 * h + (double)y));
        str = "" + scaleWM / 4.0;
        dx = (int)((double)(scale.getWidth() / 4) - g2d.getFontMetrics().getStringBounds((String)str, g2d).getWidth() / 2.0);
        g2d.drawString((String)str, dx + x, (int)(0.6 * h + (double)y));
        str = "" + scaleWM / 2.0;
        dx = (int)((double)scale.getWidth() - g2d.getFontMetrics().getStringBounds((String)str, g2d).getWidth()) / 2;
        g2d.drawString((String)str, dx + x, (int)(0.6 * h + (double)y));
        str = "" + scaleWM;
        dx = (int)((double)scale.getWidth() - g2d.getFontMetrics().getStringBounds((String)str, g2d).getWidth());
        g2d.drawString((String)str, dx + x, (int)(0.6 * h + (double)y));
        str = unit;
        dx = (int)((double)scale.getWidth() - g2d.getFontMetrics().getStringBounds((String)str, g2d).getWidth()) / 2;
        g2d.drawString((String)str, dx + x, (int)(h * 2.6 + (double)y));
    }

    public void drawStyleBar1(Graphics2D g2d, int x, int y, int w, double h) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(w / 4 - 1 + x, (int)h + y, w / 4, (int)h);
        g2d.fillRect(w * 3 / 4 - 1 + x, (int)h + y, w / 4, (int)h);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(x, (int)h + y, w / 4, (int)h);
        g2d.fillRect(w / 2 - 1 + x, (int)h + y, w / 4, (int)h);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, (int)h + y, w - 2, (int)h);
    }

    public void drawStyleBar2(Graphics2D g2d, int x, int y, int w, double h) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(w / 4 - 1 + x, (int)h + y, w / 4, (int)h / 2);
        g2d.fillRect(w * 3 / 4 - 1 + x, (int)h + y, w / 4, (int)h / 2);
        g2d.fillRect(x, (int)(h + (double)y + h / 2.0) - 1, w / 4, (int)h / 2);
        g2d.fillRect(w / 2 - 1 + x, (int)(h + (double)y + h / 2.0) - 1, w / 4, (int)h / 2);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(x, (int)h + y, w / 4, (int)(h - 1.0) / 2);
        g2d.fillRect(w / 2 - 1 + x, (int)h + y, w / 4, (int)(h - 1.0) / 2);
        g2d.fillRect(w / 4 - 1 + x, (int)(h + (double)y + h / 2.0) - 1, w / 4, (int)(h - 1.0) / 2);
        g2d.fillRect(w * 3 / 4 - 1 + x, (int)(h + (double)y + h / 2.0) - 1, w / 4, (int)(h - 1.0) / 2);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(x, (int)h + y, w - 2, (int)h);
    }

    public void drawStyleLine1(Graphics2D g2d, int x, int y, int w, double h) {
        g2d.setStroke(new BasicStroke((int)(h / 10.0)));
        g2d.setColor(Color.BLACK);
        g2d.drawLine(x, (int)((double)y + h * 3.0 / 2.0), x + w, (int)((double)y + h * 3.0 / 2.0));
        g2d.drawLine(x, (int)((double)y + h), x, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w / 4, (int)((double)y + h), x + w / 4, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w / 2, (int)((double)y + h), x + w / 2, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w * 3 / 4, (int)((double)y + h), x + w * 3 / 4, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w, (int)((double)y + h), x + w, (int)((double)y + h * 2.0));
        for (double d = 0.0; d <= 1.0; d += 0.0625) {
            g2d.drawLine((int)((double)x + (double)w * d), (int)((double)y + h + h / 4.0), (int)((double)x + (double)w * d), (int)((double)y + h * 2.0 - h / 4.0));
        }
        g2d.setStroke(new BasicStroke());
    }

    public void drawStyleLine2(Graphics2D g2d, int x, int y, int w, double h) {
        g2d.setStroke(new BasicStroke((int)(h / 5.0)));
        g2d.setColor(Color.BLACK);
        g2d.drawLine(x, (int)((double)y + h * 3.0 / 2.0), x + w, (int)((double)y + h * 3.0 / 2.0));
        g2d.drawLine(x, (int)((double)y + h), x, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w / 4, (int)((double)y + h), x + w / 4, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w / 2, (int)((double)y + h), x + w / 2, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w * 3 / 4, (int)((double)y + h), x + w * 3 / 4, (int)((double)y + h * 2.0));
        g2d.drawLine(x + w, (int)((double)y + h), x + w, (int)((double)y + h * 2.0));
        for (double d = 0.0; d <= 1.0; d += 0.0625) {
            g2d.drawLine((int)((double)x + (double)w * d), (int)((double)y + h + h / 4.0), (int)((double)x + (double)w * d), (int)((double)y + h * 2.0 - h / 4.0));
        }
        g2d.setStroke(new BasicStroke());
    }

    @Override
    public boolean isValid(Element e) {
        return e.getClass().equals(ScaleElement.class);
    }
}

