/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.millipixel.marettes.MapDocument;
import org.millipixel.marettes.elements.Element;
import org.millipixel.marettes.elements.TextElement;
import org.millipixel.marettes.renderers.G2DRenderer;
import org.millipixel.marettes.utils.Alignment;

public class TextRenderer
implements G2DRenderer<TextElement> {
    @Override
    public void render(TextElement text, Graphics2D g2d, MapDocument doc) {
        g2d.setFont(text.toFont());
        g2d.setColor(Color.BLACK);
        String[] split = text.getText().split("\n");
        ArrayList<Rectangle2D> bounds = new ArrayList<Rectangle2D>();
        for (String str : split) {
            bounds.add(g2d.getFontMetrics().getStringBounds(str, g2d));
        }
        int width = 0;
        int height = 0;
        for (Rectangle2D r : bounds) {
            width = (int)Math.max(r.getWidth(), (double)width);
            height = (int)((double)height + r.getHeight());
        }
        for (int i = 0; i < split.length; ++i) {
            int dx = 0;
            int dy = 0;
            if (text.getHAlign().equals((Object)Alignment.CENTER)) {
                dx = (text.getWidth() - (int)((Rectangle2D)bounds.get(i)).getWidth()) / 2;
            } else if (text.getHAlign().equals((Object)Alignment.RIGHT)) {
                dx = text.getWidth() - (int)((Rectangle2D)bounds.get(i)).getWidth();
            }
            if (text.getVAlign().equals((Object)Alignment.MIDDLE)) {
                dy = (text.getHeight() - height) / 2;
            } else if (text.getVAlign().equals((Object)Alignment.BOTTOM)) {
                dy = text.getHeight() - height;
            }
            g2d.drawString(split[i], text.getX() + dx, text.getY() + text.getSize() * (i + 1) + dy);
        }
    }

    @Override
    public boolean isValid(Element e) {
        return e.getClass().equals(TextElement.class);
    }
}

