/*
 * Decompiled with CFR 0.152.
 */
package org.millipixel.marettes.utils;

public enum Unit {
    MM,
    M,
    KM,
    IN,
    FT,
    MI,
    PX;

    private static final double DEFAULT_DPI = 96.0;
    private static final double IN2MM = 25.4;
    private static final double KILO = 1000.0;
    private static final double MEGA = 1000000.0;
    private static final double FT2IN = 12.0;
    private static final double MI2FT = 5280.0;
    public static double DPI;

    public static double mm2m(double mm) {
        return mm / 1000.0;
    }

    public static double m2mm(double m) {
        return m * 1000.0;
    }

    public static double mm2km(double mm) {
        return mm / 1000000.0;
    }

    public static double km2mm(double km) {
        return km * 1000000.0;
    }

    public static double mm2in(double mm) {
        return mm / 25.4;
    }

    public static double in2mm(double in) {
        return in * 25.4;
    }

    public static double mm2ft(double mm) {
        return mm / 25.4 / 12.0;
    }

    public static double ft2mm(double ft) {
        return ft / 12.0 * 25.4;
    }

    public static double mm2mi(double mm) {
        return mm / 25.4 / 12.0 / 5280.0;
    }

    public static double mi2mm(double mi) {
        return mi / 5280.0 / 12.0 * 25.4;
    }

    public static double mm2px(double mm) {
        return mm / 25.4 * DPI;
    }

    public static double px2mm(double px) {
        return px / DPI * 25.4;
    }

    public static double m2km(double m) {
        return m / 1000.0;
    }

    public static double km2m(double km) {
        return km * 1000.0;
    }

    public static double m2in(double m) {
        return m * 1000.0 / 25.4;
    }

    public static double in2m(double in) {
        return in * 25.4 / 1000.0;
    }

    public static double m2ft(double m) {
        return m * 1000.0 / 25.4 / 12.0;
    }

    public static double ft2m(double ft) {
        return ft * 12.0 * 25.4 / 1000.0;
    }

    public static double m2mi(double m) {
        return m * 1000.0 / 25.4 / 12.0 / 5280.0;
    }

    public static double mi2m(double mi) {
        return mi * 5280.0 * 12.0 * 25.4 / 1000.0;
    }

    public static double m2px(double m) {
        return m * 1000.0 / 25.4 * DPI;
    }

    public static double px2m(double px) {
        return px / DPI * 25.4 / 1000.0;
    }

    public static double km2in(double km) {
        return km * 1000000.0 / 25.4;
    }

    public static double in2km(double in) {
        return in * 25.4 / 1000000.0;
    }

    public static double km2ft(double m) {
        return m * 1000000.0 / 25.4 / 12.0;
    }

    public static double ft2km(double ft) {
        return ft * 12.0 * 25.4 / 1000000.0;
    }

    public static double km2mi(double m) {
        return m * 1000000.0 / 25.4 / 12.0 / 5280.0;
    }

    public static double mi2km(double mi) {
        return mi * 5280.0 * 12.0 * 25.4 / 1000000.0;
    }

    public static double km2px(double m) {
        return m * 1000000.0 / 25.4 * DPI;
    }

    public static double px2km(double px) {
        return px / DPI * 25.4 / 1000000.0;
    }

    public static double in2ft(double in) {
        return in / 12.0;
    }

    public static double ft2in(double ft) {
        return ft * 12.0;
    }

    public static double in2mi(double in) {
        return in / 5280.0 / 12.0;
    }

    public static double mi2in(double mi) {
        return mi * 12.0 * 5280.0;
    }

    public static double in2px(double in) {
        return in * DPI;
    }

    public static double px2in(double px) {
        return px / DPI;
    }

    public static double ft2mi(double ft) {
        return ft / 5280.0;
    }

    public static double mi2ft(double mi) {
        return mi * 5280.0;
    }

    public static double ft2px(double ft) {
        return ft * 12.0 * DPI;
    }

    public static double px2ft(double px) {
        return px / DPI / 12.0;
    }

    public static double mi2px(double mi) {
        return mi * 5280.0 * 12.0 * DPI;
    }

    public static double px2mi(double px) {
        return px / DPI / 12.0 / 5280.0;
    }

    public static double convert(double value, Unit from, Unit to) {
        if (from.equals((Object)MM)) {
            if (to.equals((Object)M)) {
                return Unit.mm2m(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.mm2km(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.mm2in(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.mm2ft(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.mm2mi(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.mm2px(value);
            }
        } else if (from.equals((Object)M)) {
            if (to.equals((Object)MM)) {
                return Unit.m2mm(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.m2km(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.m2in(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.m2ft(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.m2mi(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.m2px(value);
            }
        } else if (from.equals((Object)KM)) {
            if (to.equals((Object)MM)) {
                return Unit.km2mm(value);
            }
            if (to.equals((Object)M)) {
                return Unit.km2m(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.km2in(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.km2ft(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.km2mi(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.km2px(value);
            }
        } else if (from.equals((Object)IN)) {
            if (to.equals((Object)MM)) {
                return Unit.in2mm(value);
            }
            if (to.equals((Object)M)) {
                return Unit.in2m(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.in2km(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.in2ft(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.in2mi(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.in2px(value);
            }
        } else if (from.equals((Object)FT)) {
            if (to.equals((Object)MM)) {
                return Unit.ft2mm(value);
            }
            if (to.equals((Object)M)) {
                return Unit.ft2m(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.ft2km(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.ft2in(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.ft2mi(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.ft2px(value);
            }
        } else if (from.equals((Object)MI)) {
            if (to.equals((Object)MM)) {
                return Unit.mi2mm(value);
            }
            if (to.equals((Object)M)) {
                return Unit.mi2m(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.mi2km(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.mi2in(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.mi2ft(value);
            }
            if (to.equals((Object)PX)) {
                return Unit.mi2px(value);
            }
        } else if (from.equals((Object)PX)) {
            if (to.equals((Object)MM)) {
                return Unit.px2mm(value);
            }
            if (to.equals((Object)M)) {
                return Unit.px2m(value);
            }
            if (to.equals((Object)KM)) {
                return Unit.px2km(value);
            }
            if (to.equals((Object)IN)) {
                return Unit.px2in(value);
            }
            if (to.equals((Object)FT)) {
                return Unit.px2ft(value);
            }
            if (to.equals((Object)MI)) {
                return Unit.px2mi(value);
            }
        }
        return value;
    }

    static {
        DPI = 96.0;
    }
}

