/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.milyn.ejc.EJCException;
import org.milyn.ejc.EJCExecutor;
import org.milyn.ejc.IllegalNameException;
import org.xml.sax.SAXException;

@MojoGoal(value="generate")
@MojoPhase(value="generate-sources")
@MojoRequiresDependencyResolution
public class EJCMojo
extends AbstractMojo {
    @MojoParameter(expression="${project}", required=true, readonly=true)
    private MavenProject project;
    @MojoParameter(expression="target/ejc", required=false)
    private File destDir;
    @MojoParameter(expression="src/main/resources/edi-model.xml", required=false)
    private String ediMappingFile;
    @MojoParameter(required=false)
    private String messages;
    @MojoParameter(required=false)
    private String packageName;

    public void execute() throws MojoExecutionException {
        EJCExecutor ejc = new EJCExecutor();
        try {
            if (this.ediMappingFile.startsWith("urn:")) {
                if (this.packageName != null) {
                    throw new MojoExecutionException("Invalid EJC configuration.  'packageName' must not be configured for 'urn' mapping model configurations.");
                }
                String urn = this.ediMappingFile.substring(4).trim();
                String[] urnTokens = (urn = urn.replace("-", "_")).split(":");
                if (urnTokens.length != 3) {
                    throw new MojoExecutionException("'ediMappingFile' urn value must have a minimum of 3 colon separated tokens (4 tokens if including the leading 'urn' token).");
                }
                String directoryMapping = urnTokens[1];
                if (directoryMapping.endsWith("_mapping")) {
                    directoryMapping = directoryMapping.substring(0, directoryMapping.length() - "_mapping".length());
                }
                this.packageName = urnTokens[0] + "." + directoryMapping;
            } else {
                if (this.packageName == null) {
                    throw new MojoExecutionException("Invalid EJC configuration.  'packageName' must be configured for non 'urn' mapping model configurations.");
                }
                File mappingFileObj = new File(this.project.getBasedir(), this.ediMappingFile);
                if (mappingFileObj.exists()) {
                    this.ediMappingFile = mappingFileObj.toURI().toString();
                }
            }
            ejc.setMessages(this.messages);
            ejc.setDestDir(this.destDir);
            ejc.setEdiMappingModel(this.ediMappingFile);
            ejc.setPackageName(this.packageName);
            if (this.destDir.exists()) {
                this.destDir.delete();
            }
            ejc.execute();
            this.project.addCompileSourceRoot(this.destDir.getPath());
            Resource resource = new Resource();
            resource.setDirectory(this.destDir.getPath());
            resource.addInclude("**/*.xml");
            resource.addInclude("**/*.lst");
            this.project.addResource(resource);
        }
        catch (EJCException e) {
            throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)e);
        }
        catch (IllegalNameException e) {
            throw new MojoExecutionException("Error Executing EJC Maven Plugin.  See chained cause.", (Exception)((Object)e));
        }
    }
}

