/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;

public class URIResourceLocator
implements ContainerResourceLocator {
    private static final Log logger = LogFactory.getLog(URIResourceLocator.class);
    public static String SCHEME_CLASSPATH = "classpath";
    public static final String BASE_URI_SYSKEY = "org.milyn.resource.baseuri";
    private URI baseURI = URI.create(System.getProperty("org.milyn.resource.baseuri", "./"));

    public InputStream getResource(String configName, String defaultUri) throws IllegalArgumentException, IOException {
        return this.getResource(defaultUri);
    }

    public InputStream getResource(String uri) throws IllegalArgumentException, IOException {
        ResolvedURI resolvedURI = new ResolvedURI(uri, this.resolveURI(uri));
        return this.getResource(resolvedURI);
    }

    private InputStream getResource(ResolvedURI uri) throws IllegalArgumentException, IOException {
        InputStream stream;
        String scheme = uri.resolvedURI.getScheme();
        File fileUnresolved = new File(uri.inputURI);
        File fileResolved = null;
        if (scheme == null) {
            fileResolved = new File(uri.resolvedURI.getPath());
        }
        if (fileUnresolved.exists()) {
            stream = new FileInputStream(fileUnresolved);
        } else if (fileResolved != null && fileResolved.exists()) {
            stream = new FileInputStream(fileResolved);
        } else if (scheme == null || scheme.equals(SCHEME_CLASSPATH)) {
            String path = uri.resolvedURI.getPath();
            if (path == null || path.trim().equals("")) {
                throw new IllegalArgumentException("Unable to locate resource [" + uri + "].  Resource path not specified in URI.");
            }
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            stream = ClassUtil.getResourceAsStream(path, this.getClass());
        } else {
            URL url = uri.resolvedURI.toURL();
            URLConnection connection = url.openConnection();
            stream = connection.getInputStream();
        }
        if (stream == null) {
            throw new IOException("Failed to access data stream for resource [" + uri.inputURI + "]. Tried filesystem, classpath and URL.");
        }
        return stream;
    }

    public URI resolveURI(String uri) {
        if (uri == null || uri.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'uri' paramater in method call.");
        }
        if (uri.charAt(0) == '\\' || uri.charAt(0) == '/') {
            uri = uri.substring(1);
            return URI.create(uri);
        }
        URI uriObj = URI.create(uri);
        if (!uriObj.isAbsolute()) {
            uriObj = this.baseURI.resolve(uriObj);
        }
        return uriObj;
    }

    public void setBaseURI(URI baseURI) {
        if (baseURI == null) {
            throw new IllegalArgumentException("null 'baseURI' arg in method call.");
        }
        String baseURIString = baseURI.toString();
        char lastChar = baseURIString.charAt(baseURIString.length() - 1);
        this.baseURI = lastChar != '/' && lastChar != '\\' ? URI.create(baseURIString + '/') : baseURI;
    }

    private static class ResolvedURI {
        private String inputURI;
        private URI resolvedURI;

        private ResolvedURI(String inputURI, URI resolvedURI) {
            this.inputURI = inputURI;
            this.resolvedURI = resolvedURI;
        }
    }
}

