/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.NumberDecoder;

@DecodeType(value={BigInteger.class})
public class BigIntegerDecoder
extends NumberDecoder {
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (number instanceof BigInteger) {
                    return number;
                }
                if (number instanceof BigDecimal) {
                    return ((BigDecimal)number).toBigInteger();
                }
                return new BigInteger(String.valueOf(number.intValue()));
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode BigInteger value '" + data + "' using NumberFormat instance " + format + ".", e);
            }
        }
        try {
            return new BigInteger(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode BigInteger value '" + data + "'.", e);
        }
    }
}

