/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.milyn.assertion.AssertArgument;
import org.milyn.util.ClassUtil;
import org.milyn.xml.XmlUtil;
import org.milyn.xml.XsdValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdDOMValidator
extends XsdValidator {
    private Document document;
    private URI defaultNamespace;
    private List<URI> namespaces = new ArrayList<URI>();

    public XsdDOMValidator(Document document) throws SAXException {
        AssertArgument.isNotNull(document, "document");
        this.document = document;
        String defaultNamespaceString = XsdDOMValidator.getDefaultNamespace(document.getDocumentElement());
        if (defaultNamespaceString != null) {
            try {
                this.defaultNamespace = new URI(defaultNamespaceString);
            }
            catch (URISyntaxException e) {
                throw new SAXException("Cannot validate this document with this class.  Namespaces must be valid URIs.  Default Namespace: '" + defaultNamespaceString + "'.", e);
            }
        }
        this.gatherNamespaces(document.getDocumentElement(), this.namespaces);
        ArrayList<Source> sources = new ArrayList<Source>();
        for (int i = 0; i < this.namespaces.size(); ++i) {
            URI namespace = this.namespaces.get(i);
            if (XmlUtil.isXMLReservedNamespace(namespace.toString())) continue;
            sources.add(this.getNamespaceSource(namespace));
        }
        this.setXSDSources(sources);
    }

    public URI getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public List<URI> getNamespaces() {
        return this.namespaces;
    }

    public void validate() throws SAXException, IOException {
        this.validate(new DOMSource(this.document));
    }

    public static String getDefaultNamespace(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!"xmlns".equals(attribute.getName()) || !"xmlns".equals(attribute.getLocalName())) continue;
            return attribute.getValue();
        }
        return null;
    }

    private void gatherNamespaces(Element element, List<URI> namespaceSources) throws SAXException {
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespace = attribute.getNamespaceURI();
            if (!"http://www.w3.org/2000/xmlns/".equals(namespace)) continue;
            try {
                namespaceSources.add(new URI(attribute.getValue()));
                continue;
            }
            catch (URISyntaxException e) {
                throw new SAXException("Cannot validate this document with this class.  Namespaces must be valid URIs.  Found Namespace: '" + attribute.getValue() + "'.", e);
            }
        }
        NodeList childNodes = element.getChildNodes();
        int childCount = childNodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            this.gatherNamespaces((Element)child, namespaceSources);
        }
    }

    private Source getNamespaceSource(URI namespace) throws SAXException {
        String resourcePath = "/META-INF" + namespace.getPath();
        InputStream xsdStream = ClassUtil.getResourceAsStream(resourcePath, this.getClass());
        if (xsdStream == null) {
            throw new SAXException("Failed to locate XSD resource '" + resourcePath + "' on classpath. Namespace: '" + namespace + "'.");
        }
        return new StreamSource(xsdStream);
    }
}

