/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.io.StreamUtils;
import org.milyn.xml.XmlUtil;
import org.milyn.xml.XsdDOMValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIConfigDigester {
    public static final String XSD_V10 = "http://www.milyn.org/schema/edi-message-mapping-1.0.xsd";
    public static final String XSD_V11 = "http://www.milyn.org/schema/edi-message-mapping-1.1.xsd";
    private static final String NAMESPACE_SUFFIX = ":";

    public static Edimap digestConfig(InputStream stream) throws IOException, SAXException, EDIConfigurationException {
        Document configDoc;
        byte[] streamBuffer = StreamUtils.readStream((InputStream)stream);
        try {
            configDoc = XmlUtil.parseStream((InputStream)new ByteArrayInputStream(streamBuffer));
        }
        catch (ParserConfigurationException ee) {
            throw new SAXException("Unable to parse Smooks configuration.", ee);
        }
        XsdDOMValidator validator = new XsdDOMValidator(configDoc);
        if (validator.getNamespaces().size() == 0) {
            throw new EDIConfigurationException("The edi-message-mapping configuration must contain a namespace.");
        }
        if (validator.getNamespaces().size() > 1) {
            throw new EDIConfigurationException("Unsupported use of multiple configuration namespaces from inside the edi-message-mapping configuration.");
        }
        String ediNS = ((URI)validator.getNamespaces().get(0)).toString();
        validator.validate();
        Edimap edimap = new Edimap();
        if (!EDIConfigDigester.assertValidXSD(ediNS)) {
            throw new SAXException("Cannot parse edi-message-mapping configuration.  Unsupported default Namespace '" + ediNS + "'.");
        }
        EDIConfigDigester.digestXSDValidatedConfig(configDoc, edimap, ediNS);
        return edimap;
    }

    private static boolean assertValidXSD(String ediNS) {
        return XSD_V10.equals(ediNS) || XSD_V11.equals(ediNS);
    }

    private static void digestXSDValidatedConfig(Document configDoc, Edimap edimap, String schemaName) {
        String namespacePrefix = EDIConfigDigester.retrieveNamespace(configDoc.getDocumentElement(), schemaName) + NAMESPACE_SUFFIX;
        NodeList nodes = configDoc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "import")) {
                EDIConfigDigester.digestImport(node, edimap);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "description")) {
                EDIConfigDigester.digestDescription(node, edimap);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "delimiters")) {
                EDIConfigDigester.digestDelimiters(node, edimap);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase(namespacePrefix + "segments")) continue;
            EDIConfigDigester.digestSegments(node, edimap, namespacePrefix);
        }
    }

    private static void digestDelimiters(Node node, Edimap edimap) {
        Delimiters delimiters = new Delimiters();
        edimap.setDelimiters(delimiters);
        delimiters.setSegment(EDIConfigDigester.getNodeValue(node, "segment"));
        delimiters.setField(EDIConfigDigester.getNodeValue(node, "field"));
        delimiters.setComponent(EDIConfigDigester.getNodeValue(node, "component"));
        delimiters.setSubComponent(EDIConfigDigester.getNodeValue(node, "sub-component"));
        delimiters.setEscape(EDIConfigDigester.getNodeValue(node, "escape"));
    }

    private static void digestDescription(Node node, Edimap edimap) {
        Description description = new Description();
        edimap.setDescription(description);
        description.setName(EDIConfigDigester.getNodeValue(node, "name"));
        description.setVersion(EDIConfigDigester.getNodeValue(node, "version"));
    }

    private static void digestImport(Node node, Edimap edimap) {
        Import edimapImport = new Import();
        edimap.getImport().add(edimapImport);
        edimapImport.setResource(EDIConfigDigester.getNodeValue(node, "resource"));
        edimapImport.setNamespace(EDIConfigDigester.getNodeValue(node, "namespace"));
        edimapImport.setTruncatableFields(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatableFields"));
        edimapImport.setTruncatableComponents(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatableComponents"));
    }

    private static void digestSegments(Node node, Edimap edimap, String namespacePrefix) {
        SegmentGroup segments = new SegmentGroup();
        EDIConfigDigester.setValuesForMappingNode(node, segments);
        edimap.setSegments(segments);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            EDIConfigDigester.digestSegmentGroup(currentNode, edimap.getSegments().getSegments(), namespacePrefix);
        }
    }

    private static void digestSegment(Node node, SegmentGroup segmentGroup, String namespacePrefix) {
        if (segmentGroup instanceof Segment) {
            Segment segment = (Segment)segmentGroup;
            EDIConfigDigester.setValuesForSegment(segment, node);
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "field")) {
                    Field field = new Field();
                    segment.getFields().add(field);
                    EDIConfigDigester.digestField(currentNode, field, namespacePrefix);
                    continue;
                }
                EDIConfigDigester.digestSegmentGroup(currentNode, segment.getSegments(), namespacePrefix);
            }
        } else {
            segmentGroup.setMaxOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "maxOccurs"));
            segmentGroup.setMinOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "minOccurs"));
            EDIConfigDigester.setValuesForMappingNode(node, segmentGroup);
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node currentNode = nodes.item(i);
                EDIConfigDigester.digestSegmentGroup(currentNode, segmentGroup.getSegments(), namespacePrefix);
            }
        }
    }

    private static boolean digestSegmentGroup(Node currentNode, List<SegmentGroup> segmentGroupList, String namespacePrefix) {
        if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "segmentGroup")) {
            SegmentGroup segment = new SegmentGroup();
            segmentGroupList.add(segment);
            EDIConfigDigester.digestSegment(currentNode, segment, namespacePrefix);
            return true;
        }
        if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "segment")) {
            Segment segment = new Segment();
            segmentGroupList.add(segment);
            EDIConfigDigester.digestSegment(currentNode, segment, namespacePrefix);
            return true;
        }
        return false;
    }

    private static void digestField(Node node, Field field, String namespacePrefix) {
        EDIConfigDigester.setValuesForField(field, node);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            if (!currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "component")) continue;
            Component component = new Component();
            field.getComponent().add(component);
            EDIConfigDigester.digestComponent(currentNode, component, namespacePrefix);
        }
    }

    private static void digestComponent(Node node, Component component, String namespacePrefix) {
        EDIConfigDigester.setValuesForComponent(component, node);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            if (!currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "sub-component")) continue;
            SubComponent subComponent = new SubComponent();
            component.getSubComponent().add(subComponent);
            EDIConfigDigester.setValuesForSubComponent(currentNode, subComponent);
        }
    }

    private static void setValuesForSegment(Segment segment, Node node) {
        segment.setMaxOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "maxOccurs"));
        segment.setMinOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "minOccurs"));
        segment.setSegcode(EDIConfigDigester.getNodeValue(node, "segcode"));
        segment.setSegref(EDIConfigDigester.getNodeValue(node, "segref"));
        segment.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        EDIConfigDigester.setValuesForMappingNode(node, segment);
    }

    private static void setValuesForField(Field field, Node node) {
        field.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        field.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        EDIConfigDigester.setValuesForMappingNode(node, field);
    }

    private static void setValuesForComponent(Component component, Node node) {
        component.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        component.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        EDIConfigDigester.setValuesForMappingNode(node, component);
    }

    private static void setValuesForSubComponent(Node node, SubComponent subComponent) {
        subComponent.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        EDIConfigDigester.setValuesForMappingNode(node, subComponent);
    }

    private static void setValuesForMappingNode(Node node, MappingNode mappingNode) {
        mappingNode.setXmltag(EDIConfigDigester.getNodeValue(node, "xmltag"));
    }

    private static Boolean getNodeValueAsBoolean(Node node, String name) {
        String value = EDIConfigDigester.getNodeValue(node, name);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    private static Integer getNodeValueAsInteger(Node node, String name) {
        String value = EDIConfigDigester.getNodeValue(node, name);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    private static String getNodeValue(Node node, String name) {
        return node.getAttributes().getNamedItem(name) != null ? node.getAttributes().getNamedItem(name).getNodeValue() : null;
    }

    private static String retrieveNamespace(Element documentElement, String schemaName) {
        NamedNodeMap attributes = documentElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!node.getNodeValue().equals(schemaName)) continue;
            return node.getNodeName().replace("xmlns:", "");
        }
        return "";
    }
}

