/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.model.EDIConfigDigester;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.resource.URIResourceLocator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdifactModel {
    private Edimap edimap;

    public Edimap getEdimap() {
        return this.edimap;
    }

    public void setEdimap(Edimap edimap) {
        this.edimap = edimap;
    }

    public Delimiters getDelimiters() {
        return this.edimap.getDelimiters();
    }

    public void parseSequence(InputStream inputStream) throws SAXException, EDIConfigurationException, IOException {
        DependencyTree<String> tree = new DependencyTree<String>();
        this.edimap = EDIConfigDigester.digestConfig(inputStream);
        this.importFiles(tree.getRoot(), this.edimap, tree);
    }

    private void importFiles(Node<String> parent, Edimap edimap, DependencyTree<String> tree) throws SAXException, EDIConfigurationException, IOException {
        for (Import imp : edimap.getImport()) {
            Node<String> child = new Node<String>(imp.getResource());
            Node<String> conflictNode = tree.add(parent, child);
            if (conflictNode != null) {
                throw new EDIParseException(edimap, "Circular dependency encountered in edi-message-mapping with imported files [" + imp.getResource() + "] and [" + conflictNode.getValue() + "]");
            }
            Edimap importedEdimap = EDIConfigDigester.digestConfig(this.findUrl(imp.getResource()));
            this.importFiles(child, importedEdimap, tree);
            Map<String, Segment> importedSegments = this.createImportMap(importedEdimap);
            for (SegmentGroup segmentGroup : edimap.getSegments().getSegments()) {
                if (!(segmentGroup instanceof Segment)) continue;
                this.applyImportOnSegment((Segment)segmentGroup, imp, importedSegments);
            }
        }
    }

    private void applyImportOnSegment(Segment segment, Import imp, Map<String, Segment> importedSegments) throws EDIParseException {
        if (segment.getSegref() != null && segment.getSegref().startsWith(imp.getNamespace() + ":")) {
            String key = segment.getSegref().substring(segment.getSegref().indexOf(58) + 1);
            Segment importedSegment = importedSegments.get(key);
            if (importedSegment == null) {
                throw new EDIParseException(this.edimap, "Referenced segment [" + key + "] does not exist in imported edi-message-mapping [" + imp.getResource() + "]");
            }
            this.insertImportedSegmentInfo(segment, importedSegment, imp.isTruncatableFields(), imp.isTruncatableComponents());
        }
        for (SegmentGroup segmentGroup : segment.getSegments()) {
            if (!(segmentGroup instanceof Segment)) continue;
            this.applyImportOnSegment((Segment)segmentGroup, imp, importedSegments);
        }
    }

    private void insertImportedSegmentInfo(Segment segment, Segment importedSegment, Boolean truncatableFields, Boolean truncatableComponents) {
        segment.getFields().clear();
        segment.getFields().addAll(importedSegment.getFields());
        segment.getSegments().addAll(0, segment.getSegments());
        if (truncatableFields != null || truncatableComponents != null) {
            for (Field field : segment.getFields()) {
                field.setTruncatable(this.isTruncatable(truncatableFields, field.isTruncatable()));
                if (truncatableComponents == null) continue;
                for (Component component : field.getComponent()) {
                    component.setTruncatable(this.isTruncatable(truncatableComponents, component.isTruncatable()));
                }
            }
        }
    }

    private Map<String, Segment> createImportMap(Edimap edimap) {
        HashMap<String, Segment> result = new HashMap<String, Segment>();
        for (SegmentGroup segmentGroup : edimap.getSegments().getSegments()) {
            if (!(segmentGroup instanceof Segment)) continue;
            result.put(((Segment)segmentGroup).getSegcode(), (Segment)segmentGroup);
        }
        return result;
    }

    private InputStream findUrl(String url) throws EDIParseException {
        InputStream inputStream;
        if (url == null || url.equals("")) {
            return null;
        }
        try {
            inputStream = new URIResourceLocator().getResource(url);
        }
        catch (IOException e) {
            throw new EDIParseException(this.edimap, "Unable to locate resource [" + url + "]", e);
        }
        return inputStream;
    }

    private Boolean isTruncatable(Boolean truncatableImporting, boolean truncatableImported) {
        Boolean result = truncatableImported;
        if (truncatableImporting != null) {
            result = truncatableImporting;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<T> {
        private T value;
        private Node<T> parent;
        private List<Node<T>> children = new ArrayList<Node<T>>();

        public Node(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public void setParent(Node<T> parent) {
            this.parent = parent;
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependencyTree<T> {
        Node<T> root;

        public DependencyTree() {
            this.root = new Node<Object>(null);
        }

        public Node<T> getRoot() {
            return this.root;
        }

        public Node<T> add(Node<T> parent, Node<T> child) {
            for (Node<T> node = parent; node != null; node = node.getParent()) {
                if (node == this.root || !node.getValue().equals(child.getValue())) continue;
                return node;
            }
            child.setParent(parent);
            parent.getChildren().add(child);
            return null;
        }

        public List<T> getUniqueValues() {
            ArrayList result = new ArrayList();
            return this.getUniqueValuesForNode(this.root, result);
        }

        private List<T> getUniqueValuesForNode(Node<T> node, List<T> list) {
            if (node.getValue() != null && !list.contains(node.getValue())) {
                list.add(node.getValue());
            }
            return list;
        }
    }
}

