/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.edisax.EDIUtils;
import org.milyn.edisax.model.internal.Delimiters;
import org.xml.sax.InputSource;

class BufferedSegmentReader {
    private static Log logger = LogFactory.getLog(BufferedSegmentReader.class);
    private Reader reader;
    private StringBuffer segmentBuffer = new StringBuffer(512);
    private String[] currentSegmentFields = null;
    private int currentSegmentNumber = 0;
    private Delimiters delimiters;
    private char[] segmentDelimiter;
    private String escape;

    protected BufferedSegmentReader(InputSource ediInputSource, Delimiters delimiters) {
        this.reader = ediInputSource.getCharacterStream();
        if (this.reader == null) {
            this.reader = new InputStreamReader(ediInputSource.getByteStream());
        }
        this.delimiters = delimiters;
        this.segmentDelimiter = delimiters.getSegment().toCharArray();
        this.escape = delimiters.getEscape();
    }

    protected boolean moveToNextSegment() throws IOException {
        int c = this.reader.read();
        int delimiterLen = this.segmentDelimiter.length;
        int escapeLen = this.escape != null ? this.escape.length() : 0;
        this.segmentBuffer.setLength(0);
        this.currentSegmentFields = null;
        if (c == -1) {
            return false;
        }
        while (c != -1) {
            this.segmentBuffer.append((char)c);
            int segLen = this.segmentBuffer.length();
            if (segLen >= delimiterLen) {
                boolean reachedSegEnd = true;
                for (int i = 0; i < delimiterLen; ++i) {
                    String escapeString;
                    char delimChar;
                    char segChar = this.segmentBuffer.charAt(segLen - 1 - i);
                    if (segChar != (delimChar = this.segmentDelimiter[delimiterLen - 1 - i])) {
                        reachedSegEnd = false;
                        break;
                    }
                    if (segLen - 1 - i - escapeLen <= -1 || this.escape == null || !this.escape.equals(escapeString = this.segmentBuffer.substring(segLen - 1 - i - escapeLen, segLen - 1 - i))) continue;
                    this.segmentBuffer = this.segmentBuffer.delete(segLen - 1 - i - escapeLen, segLen - 1 - i);
                    reachedSegEnd = false;
                    break;
                }
                if (reachedSegEnd) {
                    this.segmentBuffer.setLength(segLen - delimiterLen);
                    break;
                }
            }
            c = this.reader.read();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.segmentBuffer.toString());
        }
        ++this.currentSegmentNumber;
        return true;
    }

    public boolean hasCurrentSegment() {
        return this.segmentBuffer.length() != 0;
    }

    protected StringBuffer getCurrentSegment() throws IllegalStateException {
        this.assertCurrentSegmentExists();
        return this.segmentBuffer;
    }

    protected String[] getCurrentSegmentFields() throws IllegalStateException {
        int endIndex;
        this.assertCurrentSegmentExists();
        if (this.currentSegmentFields == null) {
            this.currentSegmentFields = EDIUtils.split(this.segmentBuffer.toString(), this.delimiters.getField(), this.delimiters.getEscape());
        }
        if (this.delimiters.getSegment().equals("\n") && this.currentSegmentFields[endIndex = this.currentSegmentFields.length - 1].endsWith("\r")) {
            int stringLen = this.currentSegmentFields[endIndex].length();
            this.currentSegmentFields[endIndex] = this.currentSegmentFields[endIndex].substring(0, stringLen - 1);
        }
        return this.currentSegmentFields;
    }

    public int getCurrentSegmentNumber() {
        return this.currentSegmentNumber;
    }

    private void assertCurrentSegmentExists() {
        if (!this.hasCurrentSegment()) {
            throw new IllegalStateException("No current segment available.  Possible conditions: \n\t\t1. A call to moveToNextSegment() was not made, or \n\t\t2. The last call to moveToNextSegment() returned false.");
        }
    }
}

