/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.ControlBlockHandlerFactory;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.unedifact.handlers.r41.UNEdifact41ControlBlockHandlerFactory;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.xml.hierarchy.HierarchyChangeListener;
import org.milyn.xml.hierarchy.HierarchyChangeReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UNEdifactInterchangeParser
implements XMLReader,
HierarchyChangeReader {
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    public static final Delimiters defaultUNEdifactDelimiters = new Delimiters().setSegment("'").setField("+").setComponent(":").setEscape("?").setDecimalSeparator(".");
    private Map<Description, EdifactModel> mappingModels = new LinkedHashMap<Description, EdifactModel>();
    private ContentHandler contentHandler;
    private HierarchyChangeListener hierarchyChangeListener;
    private InterchangeContext interchangeContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource unedifactInterchange) throws IOException, SAXException {
        AssertArgument.isNotNull((Object)unedifactInterchange, (String)"unedifactInterchange");
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.mappingModels == null || this.mappingModels.isEmpty()) {
            throw new IllegalStateException("'mappingModels' not set.  Cannot parse EDI stream.");
        }
        try {
            String segCode;
            BufferedSegmentReader segmentReader = new BufferedSegmentReader(unedifactInterchange, defaultUNEdifactDelimiters);
            boolean validate = this.getFeature("http://xml.org/sax/features/validation");
            segmentReader.mark();
            segmentReader.setIgnoreNewLines(this.getFeature("http://xml.org/sax/features/ignore-newlines"));
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "unEdifact", "unEdifact", new AttributesImpl());
            while ((segCode = segmentReader.peek(3)).length() == 3) {
                UNEdifact41ControlBlockHandlerFactory controlBlockHandlerFactory = new UNEdifact41ControlBlockHandlerFactory(this.hierarchyChangeListener);
                this.interchangeContext = this.createInterchangeContext(segmentReader, validate, controlBlockHandlerFactory);
                ControlBlockHandler handler = controlBlockHandlerFactory.getControlBlockHandler(segCode);
                ++this.interchangeContext.indentDepth.value;
                handler.process(this.interchangeContext);
                --this.interchangeContext.indentDepth.value;
            }
            this.contentHandler.characters(new char[]{'\n'}, 0, 1);
            this.contentHandler.endElement("", "unEdifact", "unEdifact");
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
        }
    }

    protected InterchangeContext createInterchangeContext(BufferedSegmentReader segmentReader, boolean validate, ControlBlockHandlerFactory controlBlockHandlerFactory) {
        return new InterchangeContext(segmentReader, this.mappingModels, this.contentHandler, controlBlockHandlerFactory, validate);
    }

    public InterchangeContext getInterchangeContext() {
        return this.interchangeContext;
    }

    public Map<Description, EdifactModel> getMappingModels() {
        return this.mappingModels;
    }

    public UNEdifactInterchangeParser setMappingModels(Map<Description, EdifactModel> mappingModels) {
        AssertArgument.isNotNullAndNotEmpty(mappingModels, (String)"mappingModels");
        this.mappingModels = mappingModels;
        return this;
    }

    public UNEdifactInterchangeParser addMappingModels(Map<Description, EdifactModel> mappingModels) {
        AssertArgument.isNotNullAndNotEmpty(mappingModels, (String)"mappingModels");
        this.mappingModels.putAll(mappingModels);
        return this;
    }

    public UNEdifactInterchangeParser addMappingModels(String mappingModelFiles, URI baseURI) throws EDIConfigurationException, IOException, SAXException {
        EDIUtils.loadMappingModels(mappingModelFiles, this.mappingModels, baseURI);
        return this;
    }

    public UNEdifactInterchangeParser addMappingModel(EdifactModel mappingModel) {
        AssertArgument.isNotNull((Object)mappingModel, (String)"mappingModel");
        this.mappingModels.put(mappingModel.getEdimap().getDescription(), mappingModel);
        return this;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void ignoreNewLines(boolean ignoreNewLines) {
        this.setFeature("http://xml.org/sax/features/ignore-newlines", ignoreNewLines);
    }

    public void validate(boolean validate) {
        this.setFeature("http://xml.org/sax/features/validation", validate);
    }

    @Override
    public void setFeature(String name, boolean value) {
        this.features.put(name, value);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean feature = this.features.get(name);
        if (feature == null) {
            return false;
        }
        return feature;
    }

    public void setHierarchyChangeListener(HierarchyChangeListener listener) {
        this.hierarchyChangeListener = listener;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

