/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.model.internal.ValueNode;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.javabean.DataDecodeException;
import org.milyn.lang.MutableInt;
import org.milyn.namespace.NamespaceDeclarationStack;
import org.milyn.resource.URIResourceLocator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIParser
implements XMLReader {
    public static final String FEATURE_VALIDATE = "http://xml.org/sax/features/validation";
    public static final String FEATURE_IGNORE_NEWLINES = "http://xml.org/sax/features/ignore-newlines";
    public static final String FEATURE_IGNORE_EMPTY_NODES = "http://smooks.org/edi/sax/features/ignore-empty-nodes";
    private static final Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private Map<String, Boolean> features;
    private NamespaceDeclarationStack nsStack;
    private ContentHandler contentHandler;
    private MutableInt indentDepth;
    private static Pattern EMPTY_LINE = Pattern.compile("[\n\r ]*");
    private EdifactModel edifactModel;
    private BufferedSegmentReader segmentReader;
    private Boolean ignoreEmptyNodes;
    private static final char[] indentChars = new String("\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").toCharArray();

    public void setNamespaceDeclarationStack(NamespaceDeclarationStack nsStack) {
        this.nsStack = nsStack;
    }

    public static EdifactModel parseMappingModel(String mappingConfig, URI baseURI) throws IOException, SAXException, EDIConfigurationException {
        String ediMappingModel;
        String[] mappingConfigTokens = mappingConfig.split("!");
        Description mappingDescription = null;
        if (mappingConfigTokens.length == 1) {
            ediMappingModel = mappingConfigTokens[0];
        } else if (mappingConfigTokens.length == 3) {
            ediMappingModel = mappingConfigTokens[0];
            mappingDescription = new Description().setName(mappingConfigTokens[1]).setVersion(mappingConfigTokens[2]);
        } else if (mappingConfigTokens.length == 4) {
            ediMappingModel = mappingConfigTokens[0];
            mappingDescription = new Description().setName(mappingConfigTokens[1]).setVersion(mappingConfigTokens[2]).setNamespace(mappingConfigTokens[3]);
        } else {
            throw new EDIConfigurationException("Invalid mapping model configuration '" + mappingConfig + "'.  Must contain either 1 or 3 tokens.");
        }
        if (EDIParser.isValidURI(ediMappingModel)) {
            URIResourceLocator resourceLocator = new URIResourceLocator();
            resourceLocator.setBaseURI(baseURI);
            URI resourceURI = resourceLocator.resolveURI(ediMappingModel);
            URI importBaseURI = URIResourceLocator.extractBaseURI((URI)resourceURI);
            return EDIParser.parseMappingModel(EDIParser.getMappingConfigData(resourceLocator, ediMappingModel), mappingDescription, resourceURI, importBaseURI);
        }
        return EDIParser.parseMappingModel(new StringReader(ediMappingModel), mappingDescription, null, baseURI);
    }

    public static EdifactModel parseMappingModel(InputStream mappingConfigStream) throws IOException, SAXException, EDIConfigurationException {
        return EDIParser.parseMappingModel(mappingConfigStream, null, null, URIResourceLocator.getSystemBaseURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdifactModel parseMappingModel(InputStream mappingConfigStream, Description mappingDescription, URI resourceURI, URI importBaseURI) throws IOException, SAXException, EDIConfigurationException {
        AssertArgument.isNotNull((Object)mappingConfigStream, (String)"mappingConfigStream");
        try {
            EdifactModel edifactModel = EDIParser.parseMappingModel(new InputStreamReader(mappingConfigStream), mappingDescription, resourceURI, importBaseURI);
            return edifactModel;
        }
        finally {
            mappingConfigStream.close();
        }
    }

    public static EdifactModel parseMappingModel(Reader mappingConfigStream) throws IOException, SAXException, EDIConfigurationException {
        return EDIParser.parseMappingModel(mappingConfigStream, null, null, URIResourceLocator.getSystemBaseURI());
    }

    public static EdifactModel parseMappingModel(Reader mappingConfigStream, Description mappingDescription, URI resourceURI, URI importBaseURI) throws IOException, SAXException, EDIConfigurationException {
        AssertArgument.isNotNull((Object)mappingConfigStream, (String)"mappingConfigStream");
        AssertArgument.isNotNull((Object)importBaseURI, (String)"importBaseURI");
        EdifactModel edifactModel = new EdifactModel(resourceURI, importBaseURI, mappingConfigStream);
        edifactModel.setDescription(mappingDescription);
        return edifactModel;
    }

    private static InputStream getMappingConfigData(URIResourceLocator resourceLocator, String mappingConfig) {
        InputStream configStream = null;
        try {
            configStream = resourceLocator.getResource(mappingConfig);
        }
        catch (IOException e) {
            IllegalStateException state = new IllegalStateException("Invalid EDI mapping model config specified for " + EDIParser.class.getName() + ".  Unable to access URI based mapping model [" + resourceLocator.resolveURI(mappingConfig) + "].");
            state.initCause(e);
            throw state;
        }
        return configStream;
    }

    private static boolean isValidURI(String string) {
        try {
            new URI(string);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public void setMappingModel(EdifactModel mappingModel) {
        AssertArgument.isNotNull((Object)mappingModel, (String)"mappingModel");
        this.edifactModel = mappingModel;
    }

    public MutableInt getIndentDepth() {
        return this.indentDepth;
    }

    public void setIndentDepth(MutableInt indentDepth) {
        this.indentDepth = indentDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource ediInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.edifactModel == null || this.edifactModel.getEdimap() == null) {
            throw new IllegalStateException("'mappingModel' not set.  Cannot parse EDI stream.");
        }
        try {
            this.segmentReader = new BufferedSegmentReader(ediInputSource, this.edifactModel.getDelimiters());
            this.segmentReader.setIgnoreNewLines(this.getFeature(FEATURE_IGNORE_NEWLINES));
            this.indentDepth = new MutableInt(0);
            this.contentHandler.startDocument();
            this.parse(false);
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.segmentReader == null) {
            throw new IllegalStateException("'bufferedSegmentReader' not set.  Cannot parse EDI stream.");
        }
        if (this.edifactModel == null || this.edifactModel.getEdimap() == null) {
            throw new IllegalStateException("'mappingModel' not set.  Cannot parse EDI stream.");
        }
        try {
            this.parse(true);
        }
        finally {
            this.contentHandler = null;
        }
    }

    public EDIParser setBufferedSegmentReader(BufferedSegmentReader segmentReader) {
        this.segmentReader = segmentReader;
        return this;
    }

    private void parse(boolean indent) throws SAXException, IOException, EDIParseException {
        this.startElement(this.edifactModel.getEdimap().getSegments(), indent);
        if (this.segmentReader.moveToNextSegment()) {
            this.mapSegments(this.edifactModel.getEdimap().getSegments().getSegments());
            while (this.segmentReader.hasCurrentSegment()) {
                if (!EMPTY_LINE.matcher(this.segmentReader.getSegmentBuffer().toString()).matches()) {
                    throw new EDIParseException(this.edifactModel.getEdimap(), "Reached end of mapping model but there are more EDI segments in the incoming message.  Read " + this.segmentReader.getCurrentSegmentNumber() + " segment(s). Current EDI segment is [" + this.segmentReader.getSegmentBuffer() + "]");
                }
                this.segmentReader.moveToNextSegment();
            }
        }
        this.endElement(this.edifactModel.getEdimap().getSegments(), true);
    }

    private void mapSegments(List<SegmentGroup> expectedSegments) throws IOException, SAXException {
        this.mapSegments(expectedSegments, null);
    }

    private void mapSegments(List<SegmentGroup> expectedSegments, String[] preLoadedSegmentFields) throws IOException, SAXException {
        int segmentMappingIndex = 0;
        int segmentProcessingCount = 0;
        String[] currentSegmentFields = preLoadedSegmentFields;
        if (expectedSegments.size() == 0) {
            return;
        }
        while (segmentMappingIndex < expectedSegments.size() && this.segmentReader.hasCurrentSegment()) {
            Matcher matcher;
            SegmentGroup expectedSegmentGroup = expectedSegments.get(segmentMappingIndex);
            int minOccurs = expectedSegmentGroup.getMinOccurs();
            int maxOccurs = expectedSegmentGroup.getMaxOccurs();
            if (maxOccurs < 0) {
                maxOccurs = Integer.MAX_VALUE;
            }
            if (minOccurs > maxOccurs) {
                maxOccurs = minOccurs;
            }
            if (currentSegmentFields == null) {
                currentSegmentFields = this.segmentReader.getCurrentSegmentFields();
            }
            if (!currentSegmentFields[0].equals(expectedSegmentGroup.getSegcode()) && !(matcher = expectedSegmentGroup.getSegcodePattern().matcher(this.segmentReader.getSegmentBuffer())).matches()) {
                if (segmentProcessingCount < minOccurs) {
                    throw new EDIParseException(this.edifactModel.getEdimap(), "Must be a minimum of " + minOccurs + " instances of segment [" + expectedSegmentGroup.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedSegmentGroup, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
                }
                ++segmentMappingIndex;
                segmentProcessingCount = 0;
                continue;
            }
            if (segmentProcessingCount >= maxOccurs) {
                ++segmentMappingIndex;
                segmentProcessingCount = 0;
                continue;
            }
            if (expectedSegmentGroup instanceof Segment) {
                this.mapSegment(currentSegmentFields, (Segment)expectedSegmentGroup);
            } else {
                this.startElement(expectedSegmentGroup, true);
                this.mapSegments(expectedSegmentGroup.getSegments(), currentSegmentFields);
                this.endElement(expectedSegmentGroup, true);
            }
            currentSegmentFields = null;
            if (++segmentProcessingCount >= minOccurs || this.segmentReader.hasCurrentSegment()) continue;
            throw new EDIParseException(this.edifactModel.getEdimap(), "Reached end of EDI message stream but there must be a minimum of " + minOccurs + " instances of segment [" + expectedSegmentGroup.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedSegmentGroup, this.segmentReader.getCurrentSegmentNumber(), null);
        }
    }

    private void mapSegment(String[] currentSegmentFields, Segment expectedSegment) throws IOException, SAXException {
        this.startElement(expectedSegment, true);
        this.mapFields(currentSegmentFields, expectedSegment);
        if (this.segmentReader.moveToNextSegment()) {
            this.mapSegments(expectedSegment.getSegments());
        }
        this.endElement(expectedSegment, true);
    }

    public void mapFields(String[] currentSegmentFields, Segment segment) throws SAXException {
        String segmentCode = segment.getSegcode();
        List<Field> expectedFields = segment.getFields();
        this.assertFieldsOK(currentSegmentFields, segment);
        int numFields = currentSegmentFields.length - 1;
        int numFieldsMapped = segment.getFields().size();
        boolean ignoreUnmappedFields = segment.isIgnoreUnmappedFields();
        Delimiters delimiters = this.segmentReader.getDelimiters();
        String fieldRepeat = delimiters.getFieldRepeat();
        for (int i = 0; !(i >= numFields || ignoreUnmappedFields && i >= numFieldsMapped); ++i) {
            String fieldMessageVal = currentSegmentFields[i + 1];
            Field expectedField = expectedFields.get(i);
            if (fieldRepeat != null) {
                String[] repeatedFields;
                for (String repeatedField : repeatedFields = EDIUtils.split(fieldMessageVal, fieldRepeat, delimiters.getEscape())) {
                    this.mapField(repeatedField, expectedField, i, segmentCode);
                }
                continue;
            }
            this.mapField(fieldMessageVal, expectedField, i, segmentCode);
        }
    }

    private void mapField(String fieldMessageVal, Field expectedField, int fieldIndex, String segmentCode) throws SAXException {
        List<Component> expectedComponents = expectedField.getComponents();
        if (expectedComponents.size() != 0) {
            Delimiters delimiters = this.segmentReader.getDelimiters();
            String[] currentFieldComponents = EDIUtils.split(fieldMessageVal, delimiters.getComponent(), delimiters.getEscape());
            this.assertComponentsOK(expectedField, fieldIndex, segmentCode, expectedComponents, currentFieldComponents);
            if (currentFieldComponents.length > 0 || !this.ignoreEmptyNodes()) {
                this.startElement(expectedField, true);
                for (int i = 0; i < currentFieldComponents.length; ++i) {
                    String componentMessageVal = currentFieldComponents[i];
                    Component expectedComponent = expectedComponents.get(i);
                    this.mapComponent(componentMessageVal, expectedComponent, fieldIndex, i, segmentCode, expectedField.getXmltag());
                }
                this.endElement(expectedField, true);
            }
        } else {
            if (expectedField.isRequired() && fieldMessageVal.length() == 0) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + expectedField.getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedField, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
            if (fieldMessageVal.length() > 0 || !this.ignoreEmptyNodes()) {
                this.startElement(expectedField, true);
                this.writeToContentHandler(fieldMessageVal);
                this.endElement(expectedField, false);
            }
        }
    }

    private void mapComponent(String componentMessageVal, Component expectedComponent, int fieldIndex, int componentIndex, String segmentCode, String field) throws SAXException {
        List<SubComponent> expectedSubComponents = expectedComponent.getSubComponents();
        if (expectedSubComponents.size() != 0) {
            Delimiters delimiters = this.segmentReader.getDelimiters();
            String[] currentComponentSubComponents = EDIUtils.split(componentMessageVal, delimiters.getSubComponent(), delimiters.getEscape());
            this.assertSubComponentsOK(expectedComponent, fieldIndex, componentIndex, segmentCode, field, expectedSubComponents, currentComponentSubComponents);
            if (currentComponentSubComponents.length > 0 || !this.ignoreEmptyNodes()) {
                this.startElement(expectedComponent, true);
                for (int i = 0; i < currentComponentSubComponents.length; ++i) {
                    if (expectedSubComponents.get(i).isRequired() && currentComponentSubComponents[i].length() == 0) {
                        throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + "), sub-component " + (i + 1) + " (" + expectedSubComponents.get(i).getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedSubComponents.get(i), this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
                    }
                    this.startElement(expectedSubComponents.get(i), true);
                    this.writeToContentHandler(currentComponentSubComponents[i]);
                    this.endElement(expectedSubComponents.get(i), false);
                }
                this.endElement(expectedComponent, true);
            }
        } else {
            if (expectedComponent.isRequired() && componentMessageVal.length() == 0) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + ") expected to contain a value.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedComponent, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
            if (componentMessageVal.length() > 0 || !this.ignoreEmptyNodes()) {
                this.startElement(expectedComponent, true);
                this.writeToContentHandler(componentMessageVal);
                this.endElement(expectedComponent, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertFieldsOK(String[] currentSegmentFields, Segment segment) throws EDIParseException {
        List<Field> expectedFields = segment.getFields();
        int numFieldsExpected = expectedFields.size() + 1;
        int numberOfFieldsToValidate = 0;
        if (currentSegmentFields.length < numFieldsExpected) {
            boolean throwException = false;
            if (segment.isTruncatable()) {
                int numFieldsMissing = numFieldsExpected - currentSegmentFields.length;
                for (int i = expectedFields.size() - 1; i > expectedFields.size() - numFieldsMissing - 1; --i) {
                    if (!expectedFields.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segment.getSegcode() + "] expected to contain " + (numFieldsExpected - 1) + " fields.  Actually contains " + (currentSegmentFields.length - 1) + " fields (not including segment code).  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)segment, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
            numberOfFieldsToValidate = currentSegmentFields.length;
        } else if (currentSegmentFields.length > numFieldsExpected) {
            if (!segment.isIgnoreUnmappedFields()) throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segment.getSegcode() + "] expected to contain " + (numFieldsExpected - 1) + " fields.  Actually contains " + (currentSegmentFields.length - 1) + " fields (not including segment code).  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)segment, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            numberOfFieldsToValidate = numFieldsExpected;
        } else {
            numberOfFieldsToValidate = currentSegmentFields.length;
        }
        for (int i = 1; i < numberOfFieldsToValidate; ++i) {
            Field field = expectedFields.get(i - 1);
            if (field.getComponents().size() != 0 || currentSegmentFields[i].equals("")) continue;
            this.validateValueNode(field, currentSegmentFields[i]);
        }
    }

    private void assertComponentsOK(Field expectedField, int fieldIndex, String segmentCode, List<Component> expectedComponents, String[] currentFieldComponents) throws EDIParseException {
        if (currentFieldComponents.length != expectedComponents.size()) {
            boolean throwException = false;
            if (expectedField.isTruncatable()) {
                if (currentFieldComponents.length == 0) {
                    return;
                }
                int numComponentsMissing = expectedComponents.size() - currentFieldComponents.length;
                for (int i = expectedComponents.size() - 1; i > expectedComponents.size() - numComponentsMissing - 1; --i) {
                    if (!expectedComponents.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + expectedField.getXmltag() + ") expected to contain " + expectedComponents.size() + " components.  Actually contains " + currentFieldComponents.length + " components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedField, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
        }
        for (int i = 0; i < currentFieldComponents.length; ++i) {
            Component component = expectedComponents.get(i);
            if (component.getSubComponents().size() != 0 || currentFieldComponents[i].equals("")) continue;
            this.validateValueNode(component, currentFieldComponents[i]);
        }
    }

    private void assertSubComponentsOK(Component expectedComponent, int fieldIndex, int componentIndex, String segmentCode, String field, List<SubComponent> expectedSubComponents, String[] currentComponentSubComponents) throws EDIParseException {
        if (currentComponentSubComponents.length != expectedSubComponents.size()) {
            boolean throwException = false;
            if (expectedComponent.isTruncatable()) {
                if (currentComponentSubComponents.length == 0) {
                    return;
                }
                int numSubComponentsMissing = expectedSubComponents.size() - currentComponentSubComponents.length;
                for (int i = expectedSubComponents.size() - 1; i > expectedSubComponents.size() - numSubComponentsMissing - 1; --i) {
                    if (!expectedSubComponents.get(i).isRequired()) continue;
                    throwException = true;
                    break;
                }
            } else {
                throwException = true;
            }
            if (throwException) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + ") expected to contain " + expectedSubComponents.size() + " sub-components.  Actually contains " + currentComponentSubComponents.length + " sub-components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)expectedComponent, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
        }
        for (int i = 0; i < currentComponentSubComponents.length; ++i) {
            SubComponent subComponent = expectedSubComponents.get(i);
            if (currentComponentSubComponents[i].equals("")) continue;
            this.validateValueNode(subComponent, currentComponentSubComponents[i]);
        }
    }

    private void validateValueNode(ValueNode valueNode, String value) throws EDIParseException {
        if (!this.getFeature(FEATURE_VALIDATE)) {
            return;
        }
        if (valueNode.getDataType() != null && !valueNode.getDataType().equals("")) {
            try {
                valueNode.isValidForType(value);
            }
            catch (DataDecodeException e) {
                throw new EDIParseException(this.edifactModel.getEdimap(), "Validation of expected type [" + valueNode.getDataType() + "] failed for value [" + value + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (Exception)((Object)e), valueNode, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
            }
        }
        if (valueNode.getMinLength() != null && value.length() < valueNode.getMinLength()) {
            throw new EDIParseException(this.edifactModel.getEdimap(), "Value [" + value + "] should have a length greater than [" + valueNode.getMinLength() + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)valueNode, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
        }
        if (valueNode.getMaxLength() != null && value.length() > valueNode.getMaxLength()) {
            throw new EDIParseException(this.edifactModel.getEdimap(), "Value [" + value + "] exceeds allowed maximum length of [" + valueNode.getMaxLength() + "]. Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".", (MappingNode)valueNode, this.segmentReader.getCurrentSegmentNumber(), this.segmentReader.getCurrentSegmentFields());
        }
    }

    public void startElement(MappingNode node, boolean indent) throws SAXException {
        if (node.getXmltag() != null) {
            this.startElement(node.getXmltag(), node.getNamespace(), indent);
        }
    }

    public void startElement(String elementName, String namespace, boolean indent) throws SAXException {
        this.startElement(elementName, namespace, indent, EMPTY_ATTRIBS);
    }

    public void startElement(String elementName, String namespace, boolean indent, Attributes attributes) throws SAXException {
        if (indent) {
            this.indent();
        }
        AssertArgument.isNotNull((Object)namespace, (String)("Empty namespace detected for elemnet " + elementName));
        String nsPrefix = this.getNamespacePrefix(namespace);
        if (nsPrefix != null) {
            this.contentHandler.startElement(namespace, elementName, nsPrefix + ":" + elementName, attributes);
        } else {
            this.contentHandler.startElement(namespace, elementName, elementName, attributes);
        }
        ++this.indentDepth.value;
    }

    public void endElement(MappingNode node, boolean indent) throws SAXException {
        if (node.getXmltag() != null) {
            this.endElement(node.getXmltag(), node.getNamespace(), indent);
        }
    }

    public void endElement(String elementName, String namespace, boolean indent) throws SAXException {
        String nsPrefix;
        --this.indentDepth.value;
        if (indent) {
            this.indent();
        }
        if ((nsPrefix = this.getNamespacePrefix(namespace)) != null) {
            this.contentHandler.endElement(namespace, elementName, nsPrefix + ":" + elementName);
        } else {
            this.contentHandler.endElement(namespace, elementName, elementName);
        }
    }

    private String getNamespacePrefix(String namespace) {
        if (this.nsStack == null) {
            return null;
        }
        if (namespace == null || "".equals(namespace)) {
            return null;
        }
        return this.nsStack.getPrefix(namespace);
    }

    private void indent() throws SAXException {
        if (this.indentDepth == null) {
            throw new IllegalStateException("'indentDepth' property not set on parser instance.  Cannot indent.");
        }
        this.contentHandler.characters(indentChars, 0, this.indentDepth.value + 1);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private void writeToContentHandler(String messageVal) throws SAXException {
        if (this.edifactModel.getDelimiters() != null && this.edifactModel.getDelimiters().getEscape() != null) {
            String escapeDelimiter = this.edifactModel.getDelimiters().getEscape();
            messageVal = messageVal.replace(escapeDelimiter + escapeDelimiter, escapeDelimiter);
        }
        this.contentHandler.characters(messageVal.toCharArray(), 0, messageVal.length());
    }

    public Map<String, Boolean> getFeatures() {
        if (this.features == null) {
            this.initializeFeatures();
        }
        return this.features;
    }

    private void initializeFeatures() {
        this.features = new HashMap<String, Boolean>();
        this.features.put(FEATURE_VALIDATE, false);
        this.features.put(FEATURE_IGNORE_NEWLINES, false);
        this.features.put(FEATURE_IGNORE_EMPTY_NODES, true);
    }

    private boolean ignoreEmptyNodes() {
        if (this.ignoreEmptyNodes == null) {
            this.ignoreEmptyNodes = this.getFeature(FEATURE_IGNORE_EMPTY_NODES);
        }
        return this.ignoreEmptyNodes;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    @Override
    public boolean getFeature(String name) {
        return this.getFeatures().get(name);
    }

    @Override
    public void setFeature(String name, boolean value) {
        this.getFeatures().put(name, value);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

