/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.invoker;

import java.util.Map;
import org.milyn.scribe.Dao;
import org.milyn.scribe.Flushable;
import org.milyn.scribe.Locator;
import org.milyn.scribe.MappingDao;
import org.milyn.scribe.Queryable;
import org.milyn.scribe.invoker.DaoInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceDaoInvoker
implements DaoInvoker {
    private final Dao<Object> dao;
    private final MappingDao<Object> mappingDao;
    private final Queryable queryFinderDAO;
    private final Locator finderDAO;
    private final Flushable flushableDAO;

    InterfaceDaoInvoker(Object dao) {
        this.dao = dao instanceof Dao ? (Dao)dao : null;
        this.mappingDao = dao instanceof MappingDao ? (MappingDao)dao : null;
        this.queryFinderDAO = dao instanceof Queryable ? (Queryable)dao : null;
        this.finderDAO = dao instanceof Locator ? (Locator)dao : null;
        this.flushableDAO = dao instanceof Flushable ? (Flushable)dao : null;
    }

    @Override
    public Object insert(Object obj) {
        if (this.dao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Dao.class.getName() + "' interface and there for can't insert the entity.");
        }
        return this.dao.insert(obj);
    }

    @Override
    public Object insert(String name, Object obj) {
        if (this.mappingDao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.mappingDao.getClass().getName() + "' doesn't implement the '" + MappingDao.class.getName() + "' interface and there for can't insert the entity under the name '" + name + "'.");
        }
        return this.mappingDao.insert(name, obj);
    }

    @Override
    public Object update(Object obj) {
        if (this.dao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Dao.class.getName() + "' interface and there for can't insert the entity.");
        }
        return this.dao.update(obj);
    }

    @Override
    public Object update(String name, Object obj) {
        if (this.mappingDao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.mappingDao.getClass().getName() + "' doesn't implement the '" + MappingDao.class.getName() + "' interface and there for can't update the entity under the name '" + name + "'.");
        }
        return this.mappingDao.update(name, obj);
    }

    @Override
    public Object delete(Object entity) {
        if (this.dao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Dao.class.getName() + "' interface and there for can't delete the entity.");
        }
        return this.dao.delete(entity);
    }

    @Override
    public Object delete(String name, Object entity) {
        if (this.mappingDao == null) {
            throw new UnsupportedOperationException("The DAO '" + this.mappingDao.getClass().getName() + "' doesn't implement the '" + MappingDao.class.getName() + "' interface and there for can't delete the entity under the name '" + name + "'.");
        }
        return this.mappingDao.delete(name, entity);
    }

    @Override
    public void flush() {
        if (this.flushableDAO == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Flushable.class.getName() + "' interface and there for can't flush the DAO.");
        }
        this.flushableDAO.flush();
    }

    @Override
    public Object lookupByQuery(String query, Object ... parameters) {
        if (this.queryFinderDAO == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Queryable.class.getName() + "' interface and there for can't find by query.");
        }
        return this.queryFinderDAO.lookupByQuery(query, parameters);
    }

    @Override
    public Object lookupByQuery(String query, Map<String, ?> parameters) {
        if (this.queryFinderDAO == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Queryable.class.getName() + "' interface and there for can't find by query.");
        }
        return this.queryFinderDAO.lookupByQuery(query, parameters);
    }

    @Override
    public Object lookup(String name, Object ... parameters) {
        if (this.finderDAO == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Locator.class.getName() + "' interface and there for can't find by query.");
        }
        return this.finderDAO.lookup(name, parameters);
    }

    @Override
    public Object lookup(String name, Map<String, ?> parameters) {
        if (this.finderDAO == null) {
            throw new UnsupportedOperationException("The DAO '" + this.dao.getClass().getName() + "' doesn't implement the '" + Locator.class.getName() + "' interface and there for can't find by query.");
        }
        return this.finderDAO.lookup(name, parameters);
    }
}

