/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact;

import java.util.Map;
import java.util.Set;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UNEdifactUtil {
    public static EdifactModel getMappingModel(String messageName, Delimiters delimiters, Map<Description, EdifactModel> mappingModels) throws SAXException {
        Set<Map.Entry<Description, EdifactModel>> modelSet = mappingModels.entrySet();
        String[] nameComponents = EDIUtils.split(messageName, delimiters.getComponent(), delimiters.getEscape());
        StringBuilder lookupNameBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                lookupNameBuilder.append(':');
            }
            lookupNameBuilder.append(nameComponents[i]);
        }
        String lookupName = lookupNameBuilder.toString().trim();
        for (Map.Entry<Description, EdifactModel> mappingModel : modelSet) {
            Description description = mappingModel.getKey();
            String compoundName = description.getName() + ":" + description.getVersion();
            if (!compoundName.equals(lookupName)) continue;
            return mappingModel.getValue();
        }
        throw new SAXException("Mapping Model '" + messageName + "' not found in supplied set of Mapping model.");
    }
}

