/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.adapter.hibernate;

import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.Dao;
import org.milyn.scribe.Flushable;
import org.milyn.scribe.Locator;
import org.milyn.scribe.Queryable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionDaoAdapter
implements Dao<Object>,
Locator,
Queryable,
Flushable {
    private final Session session;

    public SessionDaoAdapter(Session session) {
        AssertArgument.isNotNull(session, "session");
        this.session = session;
    }

    @Override
    public void flush() {
        this.session.flush();
    }

    @Override
    public Object update(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        this.session.update(entity);
        return entity;
    }

    @Override
    public Object insert(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        this.session.save(entity);
        return null;
    }

    @Override
    public Object delete(Object entity) {
        AssertArgument.isNotNull(entity, "entity");
        this.session.delete(entity);
        return null;
    }

    @Override
    public Object lookup(String name, Object ... parameters) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(parameters, "parameters");
        Query query = this.session.getNamedQuery(name);
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i + 1, parameters[i]);
        }
        return query.list();
    }

    @Override
    public Object lookup(String name, Map<String, ?> parameters) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(parameters, "parameters");
        Query query = this.session.getNamedQuery(name);
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query.list();
    }

    @Override
    public Object lookupByQuery(String query, Object ... parameters) {
        AssertArgument.isNotNullAndNotEmpty(query, "query");
        AssertArgument.isNotNull(parameters, "parameters");
        if (query.startsWith("@")) {
            return this.lookup(query.substring(1), parameters);
        }
        Query sesQuery = this.session.createQuery(query);
        for (int i = 0; i < parameters.length; ++i) {
            sesQuery.setParameter(i + 1, parameters[i]);
        }
        return sesQuery.list();
    }

    @Override
    public Object lookupByQuery(String query, Map<String, ?> parameters) {
        AssertArgument.isNotNullAndNotEmpty(query, "query");
        AssertArgument.isNotNull(parameters, "parameters");
        if (query.startsWith("@")) {
            return this.lookup(query.substring(1), parameters);
        }
        Query sesQuery = this.session.createQuery(query);
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            sesQuery.setParameter(entry.getKey(), entry.getValue());
        }
        return sesQuery.list();
    }

    public Session getSession() {
        return this.session;
    }
}

