/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath.evaluators;

import java.util.List;
import java.util.Properties;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.saxpath.SAXPathException;
import org.milyn.cdr.xpath.SelectorStep;
import org.milyn.cdr.xpath.evaluators.PredicatesEvaluator;
import org.milyn.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.milyn.xml.Namespace;

public class PredicatesEvaluatorBuilder {
    private Step step;
    private Step attributeStep;
    private SelectorStep selectorStep;
    private Properties namespaces;

    public PredicatesEvaluatorBuilder(Step step, Step attributeStep, SelectorStep selectorStep, Properties namespaces) {
        this.step = step;
        this.attributeStep = attributeStep;
        this.selectorStep = selectorStep;
        this.namespaces = namespaces;
        if (attributeStep != null && attributeStep.getAxis() != 9) {
            throw new IllegalStateException("Unexpected 'attributeStep' arg '" + attributeStep.getText() + "'.  Must be an ATTRIBUTE Axis step.");
        }
    }

    public XPathExpressionEvaluator build() throws SAXPathException, NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException {
        PredicatesEvaluator evaluator = new PredicatesEvaluator();
        if (!(this.step instanceof NameStep)) {
            throw new SAXPathException("Unsupported step '" + this.step.getText() + "'.");
        }
        this.addEvaluators(this.step, evaluator);
        if (this.attributeStep != null) {
            this.addEvaluators(this.attributeStep, evaluator);
        }
        return evaluator;
    }

    private void addEvaluators(Step step, PredicatesEvaluator evaluator) throws SAXPathException {
        List predicates = step.getPredicates();
        for (Predicate predicate : predicates) {
            XPathExpressionEvaluator predicateEvaluator = XPathExpressionEvaluator.getInstance(predicate.getExpr(), this.selectorStep, this.namespaces);
            evaluator.addEvaluator(predicateEvaluator);
        }
    }

    public String getNamespace(String nsPrefix) throws SAXPathException {
        return PredicatesEvaluatorBuilder.getNamespace(nsPrefix, this.namespaces);
    }

    public static String getNamespace(String nsPrefix, Properties namespaces) throws SAXPathException {
        String namespace = namespaces.getProperty(nsPrefix);
        if (namespace == null && (namespace = Namespace.SMOOKS_PREFIX_MAPPINGS.getProperty(nsPrefix)) == null) {
            throw new SAXPathException("Unknown namespace prefix '" + nsPrefix + "'.  You must define the namespace prefix-to-uri mappings in the Smooks <core:namespaces> configuration section.");
        }
        return namespace;
    }
}

