/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath.evaluators.value;

import java.util.List;
import java.util.Properties;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.saxpath.SAXPathException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.xpath.evaluators.PredicatesEvaluatorBuilder;
import org.milyn.cdr.xpath.evaluators.value.AbsoluteValue;
import org.milyn.cdr.xpath.evaluators.value.AttributeValue;
import org.milyn.cdr.xpath.evaluators.value.TextValue;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.javabean.DataDecoder;
import org.w3c.dom.Element;

public abstract class Value {
    public abstract Object getValue(SAXElement var1);

    public abstract Object getValue(Element var1);

    public static Value getValue(Expr expr, DataDecoder decoder, Properties namespaces) throws SAXPathException {
        AssertArgument.isNotNull(expr, "expr");
        if (expr instanceof LocationPath) {
            LocationPath locationPath = (LocationPath)expr;
            List steps = locationPath.getSteps();
            if (steps != null && steps.size() == 1) {
                Step step = (Step)steps.get(0);
                if (step.getAxis() == 1 && step instanceof TextNodeStep) {
                    return new TextValue(decoder);
                }
                if (step.getAxis() == 9 && step instanceof NameStep) {
                    String nsPrefix = ((NameStep)step).getPrefix();
                    String localPart = ((NameStep)step).getLocalName();
                    if (nsPrefix != null && !nsPrefix.trim().equals("")) {
                        return new AttributeValue(PredicatesEvaluatorBuilder.getNamespace(nsPrefix, namespaces), localPart, decoder);
                    }
                    return new AttributeValue(null, localPart, decoder);
                }
            }
        } else {
            if (expr instanceof NumberExpr) {
                return new AbsoluteValue((NumberExpr)expr);
            }
            if (expr instanceof LiteralExpr) {
                return new AbsoluteValue((LiteralExpr)expr);
            }
        }
        throw new SAXPathException("Unsupported XPath value token '" + expr.getText() + "'.");
    }
}

