/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.visitor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.milyn.SmooksException;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.dom.serialize.DefaultSerializationUnit;
import org.milyn.javabean.dynamic.BeanMetadata;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownElementDataReaper {
    private static DefaultSerializationUnit serializationUnit = new DefaultSerializationUnit();

    public static String getPreText(Element element, List<BeanMetadata> beanMetadataSet, BeanContextLifecycleEvent event) {
        String xml;
        StringWriter serializeWriter = new StringWriter();
        ArrayList<Element> toSerializeNodes = new ArrayList<Element>();
        Node current = element;
        while (!(current == null || (current = current.getPreviousSibling()) == null || current instanceof Element && UnknownElementDataReaper.isOnModelSourcePath(new Fragment((Element)current), beanMetadataSet))) {
            toSerializeNodes.add(0, (Element)current);
        }
        for (Node node : toSerializeNodes) {
            try {
                UnknownElementDataReaper.serialize(node, serializeWriter);
            }
            catch (IOException e) {
                throw new SmooksException("Unexpected pre-text node serialization exception.", e);
            }
        }
        try {
            xml = UnknownElementDataReaper.normalizeLines(serializeWriter.toString());
        }
        catch (IOException iOException) {
            throw new SmooksException("Unexpected pre-text node serialization exception while attempting to remove excess whitespace.", iOException);
        }
        StringBuilder stringBuilder = new StringBuilder(xml);
        while (stringBuilder.length() > 0 && stringBuilder.charAt(0) == ' ') {
            stringBuilder.deleteCharAt(0);
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(0) == '\n' && stringBuilder.charAt(1) == '\n') {
            stringBuilder.deleteCharAt(0);
        }
        while (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '\n' && stringBuilder.charAt(stringBuilder.length() - 2) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static boolean isOnModelSourcePath(Fragment fragment, List<BeanMetadata> beanMetadataSet) {
        for (BeanMetadata beanMetadata : beanMetadataSet) {
            if (fragment.equals(beanMetadata.getCreateSource())) {
                return true;
            }
            for (Fragment populateSource : beanMetadata.getPopulateSources()) {
                if (!fragment.isParentFragment(populateSource)) continue;
                return true;
            }
        }
        return false;
    }

    public static String normalizeLines(String xml) throws IOException {
        StringBuffer stringBuf = new StringBuffer();
        int xmlLength = xml.length();
        for (int i = 0; i < xmlLength; ++i) {
            char character = xml.charAt(i);
            if (character == '\r') continue;
            stringBuf.append(character);
        }
        return stringBuf.toString();
    }

    private static void serialize(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Element element = (Element)node;
                NodeList children = element.getChildNodes();
                int childCount = children.getLength();
                serializationUnit.writeElementStart(element, writer);
                for (int i = 0; i < childCount; ++i) {
                    UnknownElementDataReaper.serialize(children.item(i), writer);
                }
                serializationUnit.writeElementEnd(element, writer);
                break;
            }
            case 3: {
                serializationUnit.writeElementText((Text)node, writer, null);
                break;
            }
            case 8: {
                serializationUnit.writeElementComment((Comment)node, writer, null);
                break;
            }
            case 4: {
                serializationUnit.writeElementCDATA((CDATASection)node, writer, null);
                break;
            }
            case 5: {
                serializationUnit.writeElementEntityRef((EntityReference)node, writer, null);
                break;
            }
        }
    }

    static {
        serializationUnit.setCloseEmptyElements(true);
        serializationUnit.setRewriteEntities(true);
    }
}

