/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.javabean.BeanInstanceCreator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.binding.model.Binding;
import org.milyn.javabean.binding.model.WiredBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean {
    private BeanInstanceCreator creator;
    private String beanId;
    private boolean cloneable = false;
    private Bean wiredInto;
    private List<Binding> bindings = new ArrayList<Binding>();

    public Bean(BeanInstanceCreator creator) {
        this.creator = creator;
        this.beanId = creator.getBeanId();
    }

    public SmooksResourceConfiguration getConfig() {
        return this.creator.getConfig();
    }

    public BeanInstanceCreator getCreator() {
        return this.creator;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public Bean setCloneable(boolean cloneable) {
        this.cloneable = cloneable;
        return this;
    }

    public Bean getWiredInto() {
        return this.wiredInto;
    }

    public Bean wiredInto(Bean wiredInto) {
        if (this.cloneable) {
            throw new IllegalStateException("Illegal wiring of a bean that is cloneable.  Only non cloneable beans (e.g. non base beans) can be wired together.");
        }
        this.wiredInto = wiredInto;
        return this;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public WiredBinding getWiredBinding(Bean wiredBean) {
        for (Binding binding : this.bindings) {
            WiredBinding wiredBinding;
            if (!(binding instanceof WiredBinding) || (wiredBinding = (WiredBinding)binding).getWiredBean() != wiredBean) continue;
            return wiredBinding;
        }
        return null;
    }

    protected Bean clone(Map<String, Bean> baseBeans, Bean parentBean) {
        if (!this.cloneable) {
            throw new IllegalStateException("Illegal call to clone a Bean instance that is not cloneable.");
        }
        Bean beanClone = new Bean(this.creator).wiredInto(parentBean);
        for (Binding binding : this.bindings) {
            Binding bindingClone = (Binding)binding.clone();
            bindingClone.setParentBean(beanClone);
            if (bindingClone instanceof WiredBinding) {
                WiredBinding wiredBinding = (WiredBinding)bindingClone;
                String wiredBeanId = wiredBinding.getWiredBeanId();
                Bean beanToBeWired = baseBeans.get(wiredBeanId);
                if (beanToBeWired == null || parentBean != null && (parentBean.getBeanId().equals(wiredBeanId) || parentBean.getParentBean(wiredBeanId) != null)) continue;
                wiredBinding.setWiredBean(beanToBeWired.clone(baseBeans, beanClone));
                beanClone.bindings.add(wiredBinding);
                continue;
            }
            beanClone.bindings.add(bindingClone);
        }
        return beanClone;
    }

    public Bean getParentBean(String beanId) {
        if (this.wiredInto != null) {
            if (this.wiredInto.getBeanId().equals(beanId)) {
                return this.wiredInto;
            }
            return this.wiredInto.getParentBean(beanId);
        }
        return null;
    }

    public Class<?> getBeanClass() {
        return this.creator.getBeanRuntimeInfo().getPopulateType();
    }

    public boolean isCollection() {
        BeanRuntimeInfo.Classification classification = this.creator.getBeanRuntimeInfo().getClassification();
        return classification == BeanRuntimeInfo.Classification.COLLECTION_COLLECTION || classification == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
    }

    public String toString() {
        return this.beanId;
    }
}

