/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.csv.CSVBindingType;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.Bean;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.xml.SmooksXMLReader;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class CSVReader
implements SmooksXMLReader,
VisitorAppender {
    private static Log logger = LogFactory.getLog(CSVReader.class);
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static final String IGNORE_FIELD = "$ignore$";
    private static char[] INDENT_LF = new char[]{'\n'};
    private static char[] INDENT_1 = new char[]{'\t'};
    private static char[] INDENT_2 = new char[]{'\t', '\t'};
    private ContentHandler contentHandler;
    private ExecutionContext request;
    @ConfigParam(name="fields")
    private String[] csvFields;
    @ConfigParam(defaultVal=",")
    private char separator;
    @ConfigParam(name="quote-char", defaultVal="\"")
    private char quoteChar;
    @ConfigParam(name="skip-line-count", defaultVal="0")
    private int skipLines;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    @ConfigParam(defaultVal="csv-set")
    private String rootElementName;
    @ConfigParam(defaultVal="csv-record")
    private String recordElementName;
    @ConfigParam(defaultVal="false")
    private boolean indent;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindBeanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Class bindBeanClass;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private CSVBindingType bindingType;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindMapKeyField;
    private static final String RECORD_BEAN = "csvRecordBean";

    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.bindBeanId != null && this.bindBeanClass != null) {
            if (this.bindingType == CSVBindingType.LIST) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId, "$document");
                Bean bean = listBean.newBean(this.bindBeanClass, this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                listBean.addVisitors(visitorMap);
            } else if (this.bindingType == CSVBindingType.MAP) {
                if (this.bindMapKeyField == null) {
                    throw new SmooksConfigurationException("CSV 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.assertValidFieldName(this.bindMapKeyField);
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId, "$document");
                Bean recordBean = new Bean(this.bindBeanClass, RECORD_BEAN, this.recordElementName);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField, this.bindBeanId);
                this.addFieldBindings(recordBean);
                mapBean.addVisitors(visitorMap);
                recordBean.addVisitors(visitorMap);
                visitorMap.addVisitor((Visitor)wiringVisitor, this.recordElementName, null, false);
            } else {
                Bean bean = new Bean(this.bindBeanClass, this.bindBeanId, this.recordElementName);
                this.addFieldBindings(bean);
                bean.addVisitors(visitorMap);
            }
        }
    }

    private void addFieldBindings(Bean bean) {
        for (int i = 0; i < this.csvFields.length; ++i) {
            String field = this.csvFields[i];
            if (field.equals(IGNORE_FIELD)) continue;
            bean.bindTo(field, this.recordElementName + "/" + field);
        }
    }

    public void setExecutionContext(ExecutionContext request) {
        this.request = request;
    }

    public void parse(InputSource csvInputSource) throws IOException, SAXException {
        String[] csvRecord;
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse CSV stream.");
        }
        if (this.request == null) {
            throw new IllegalStateException("Smooks container 'request' not set.  Cannot parse CSV stream.");
        }
        Reader csvStreamReader = csvInputSource.getCharacterStream();
        if (csvStreamReader == null) {
            csvStreamReader = new InputStreamReader(csvInputSource.getByteStream(), this.encoding);
        }
        au.com.bytecode.opencsv.CSVReader csvLineReader = new au.com.bytecode.opencsv.CSVReader(csvStreamReader, this.separator, this.quoteChar, this.skipLines);
        this.contentHandler.startDocument();
        this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
        int lineNumber = 0;
        int expectedCount = this.getExpectedColumnsCount();
        while ((csvRecord = csvLineReader.readNext()) != null) {
            ++lineNumber;
            if (csvRecord.length < expectedCount) {
                logger.warn((Object)("[CORRUPT-CSV] CSV line #" + lineNumber + " invalid [" + Arrays.asList(csvRecord) + "].  The line should contain number of items at least as in CSV config file " + this.csvFields.length + " fields [" + this.csvFields + "], but contains " + csvRecord.length + " fields.  Ignoring!!"));
                continue;
            }
            if (this.indent) {
                this.contentHandler.characters(INDENT_LF, 0, 1);
                this.contentHandler.characters(INDENT_1, 0, 1);
            }
            this.contentHandler.startElement("", this.recordElementName, "", EMPTY_ATTRIBS);
            int recordIt = 0;
            for (int fieldIt = 0; fieldIt < this.csvFields.length; ++fieldIt) {
                String fieldName = this.csvFields[fieldIt];
                if (fieldName.startsWith(IGNORE_FIELD)) {
                    int toSkip = this.parseIgnoreFieldDirective(fieldName);
                    if (toSkip == Integer.MAX_VALUE) break;
                    recordIt += toSkip;
                    continue;
                }
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_2, 0, 2);
                }
                this.contentHandler.startElement("", fieldName, "", EMPTY_ATTRIBS);
                this.contentHandler.characters(csvRecord[recordIt].toCharArray(), 0, csvRecord[recordIt].length());
                this.contentHandler.endElement("", fieldName, "");
                if (this.indent) {
                    // empty if block
                }
                ++recordIt;
            }
            if (this.indent) {
                this.contentHandler.characters(INDENT_LF, 0, 1);
                this.contentHandler.characters(INDENT_1, 0, 1);
            }
            this.contentHandler.endElement(null, this.recordElementName, "");
        }
        if (this.indent) {
            this.contentHandler.characters(INDENT_LF, 0, 1);
        }
        this.contentHandler.endElement("", this.rootElementName, "");
        this.contentHandler.endDocument();
    }

    private int parseIgnoreFieldDirective(String field) {
        String op = field.substring(IGNORE_FIELD.length());
        int toSkip = 0;
        toSkip = op.length() == 0 ? 1 : ("+".equals(op) ? Integer.MAX_VALUE : Integer.parseInt(op));
        return toSkip;
    }

    private int getExpectedColumnsCount() {
        int count = 0;
        for (int i = 0; i < this.csvFields.length; ++i) {
            String field = this.csvFields[i];
            if (field.startsWith(IGNORE_FIELD)) continue;
            ++count;
        }
        return count;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private void assertValidFieldName(String field) {
        for (String csvField : this.csvFields) {
            if (!csvField.equals(field)) continue;
            return;
        }
        throw new SmooksConfigurationException("Invalid field name '" + field + "'.  Valid names: " + Arrays.asList(this.csvFields) + ".");
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private class MapBindingWiringVisitor
    implements DOMVisitAfter,
    SAXVisitAfter,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("csvRecordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanRepository repository = BeanRepositoryManager.getBeanRepository((ExecutionContext)executionContext);
            Map beanMap = repository.getBeanMap();
            Object key = this.keyExtractor.getValue((Object)beanMap);
            Map map = (Map)repository.getBean(this.mapBindingKey);
            Object record = repository.getBean(CSVReader.RECORD_BEAN);
            map.put(key, record);
        }

        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }
}

