/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.milyn.FilterSettings;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.assertion.AssertArgument;
import org.milyn.csv.CSVBinding;
import org.milyn.csv.CSVBindingType;
import org.milyn.csv.CSVReaderConfigurator;
import org.milyn.payload.JavaResult;

public class CSVMapBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public CSVMapBinder(String fields, Class recordType, String keyField) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull((Object)recordType, (String)"recordType");
        AssertArgument.isNotNullAndNotEmpty((String)keyField, (String)"keyField");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig((ReaderConfigurator)new CSVReaderConfigurator(fields).setBinding(new CSVBinding(this.beanId, recordType, CSVBindingType.MAP).setKeyField(keyField)));
    }

    public Map bind(Reader csvStream) {
        AssertArgument.isNotNull((Object)csvStream, (String)"csvStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(csvStream), new Result[]{javaResult});
        return (Map)javaResult.getBean(this.beanId);
    }

    public Map bind(InputStream csvStream) {
        return this.bind(new InputStreamReader(csvStream));
    }
}

