/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.ect.EdiParseException;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnCefactDefinitionReader {
    private static final String ELEMENT_SEPARATOR = "^-+$";
    private static final String DOTS = "\\.\\.";
    private static final Pattern WHOLE_DATA_ELEMENT = Pattern.compile("^(\\d{3}) *(\\d{4}) *(.*) *.*(C|M) *(an|n|a)(\\.*)(\\d*)");
    private static final Pattern FIRST_DATA_ELEMENT_PART = Pattern.compile("^(\\d{3}) *(\\d{4}) *(.*) *");
    private static final Pattern SECOND_DATA_ELEMENT_PART = Pattern.compile(" *(.*) *.*(C|M) *(an|n|a)(\\.*)(\\d*)");
    private static final Pattern ELEMENT_HEADER = Pattern.compile("[X ]*(\\w{4}) *(.*) *\\[(\\w)\\]");
    private static final Pattern COMPOSITE_HEADER = Pattern.compile(" *(\\w{4}) *(.*)");
    private static final Pattern SEGMENT_HEADER = Pattern.compile(" *(\\w{3}) *(.*)");
    private static final Pattern SEGMENT_ELEMENT = Pattern.compile("^(\\d{3}) *(\\d{4}|C\\d{3}) *(.*) *(C|M).*");

    public static List<Segment> readSegmentDefinitions(Reader dataReader, Reader compositeReader, Reader segmentReader) throws IOException, EdiParseException {
        Map<String, Component> datas = UnCefactDefinitionReader.readComponents(dataReader);
        Map<String, Field> composites = UnCefactDefinitionReader.readFields(compositeReader, datas);
        return UnCefactDefinitionReader.readSegments(segmentReader, composites, datas);
    }

    private static List<Segment> readSegments(Reader reader, Map<String, Field> composites, Map<String, Component> datas) throws IOException, EdiParseException {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        BufferedReader _reader = new BufferedReader(reader);
        UnCefactDefinitionReader.moveToNextPart(_reader);
        Segment segment = UnCefactDefinitionReader.getSegment(_reader, composites, datas);
        while (segment != null) {
            segments.add(segment);
            segment = UnCefactDefinitionReader.getSegment(_reader, composites, datas);
        }
        return segments;
    }

    private static Segment getSegment(BufferedReader reader, Map<String, Field> fields, Map<String, Component> componens) throws IOException, EdiParseException {
        String line = UnCefactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = SEGMENT_HEADER.matcher(line);
        if (!headerMatcher.matches()) {
            throw new EdiParseException("Unable to extract segment code and name for Segment from line [" + line + "].");
        }
        String segcode = headerMatcher.group(1);
        String name = headerMatcher.group(2);
        String description = UnCefactDefinitionReader.getValue(reader, "Function:");
        Segment segment = new Segment();
        segment.setSegcode(segcode);
        segment.setXmltag(name.trim());
        segment.setDescription(description);
        line = UnCefactDefinitionReader.readUntilValue(reader);
        while (line != null && !line.matches(ELEMENT_SEPARATOR)) {
            Matcher matcher = SEGMENT_ELEMENT.matcher(line);
            if (matcher.matches()) {
                if (matcher.group(2).startsWith("C")) {
                    segment.getFields().add(UnCefactDefinitionReader.copyField(fields.get(matcher.group(2)), matcher.group(4).equalsIgnoreCase("M")));
                } else {
                    segment.getFields().add(UnCefactDefinitionReader.convertToField(componens.get(matcher.group(2)), matcher.group(4).equalsIgnoreCase("M")));
                }
            }
            line = reader.readLine();
        }
        return segment;
    }

    private static Field convertToField(Component component, boolean isMandatory) {
        Field field = new Field();
        field.setXmltag(component.getXmltag());
        field.setDocumentation(component.getDocumentation());
        field.setMaxLength(component.getMaxLength());
        field.setMinLength(component.getMinLength());
        field.setRequired(Boolean.valueOf(isMandatory));
        field.setTruncatable(Boolean.valueOf(component.isTruncatable()));
        field.setType(component.getType());
        field.setTypeParameters(component.getTypeParameters());
        return field;
    }

    private static Field copyField(Field oldField, boolean isMandatory) {
        Field field = new Field();
        field.setXmltag(oldField.getXmltag());
        field.setDocumentation(oldField.getDocumentation());
        field.setMaxLength(oldField.getMaxLength());
        field.setMinLength(oldField.getMinLength());
        field.setRequired(Boolean.valueOf(isMandatory));
        field.setTruncatable(Boolean.valueOf(oldField.isTruncatable()));
        field.setType(oldField.getType());
        field.setTypeParameters(oldField.getTypeParameters());
        field.getComponent().addAll(oldField.getComponent());
        return field;
    }

    private static Map<String, Field> readFields(Reader reader, Map<String, Component> components) throws IOException, EdiParseException {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        BufferedReader _reader = new BufferedReader(reader);
        UnCefactDefinitionReader.moveToNextPart(_reader);
        Field field = new Field();
        String id = UnCefactDefinitionReader.populateField(_reader, components, field);
        while (id != null) {
            fields.put(id, field);
            UnCefactDefinitionReader.moveToNextPart(_reader);
            field = new Field();
            id = UnCefactDefinitionReader.populateField(_reader, components, field);
        }
        return fields;
    }

    private static String populateField(BufferedReader reader, Map<String, Component> components, Field field) throws IOException, EdiParseException {
        String line = UnCefactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = COMPOSITE_HEADER.matcher(line);
        if (!headerMatcher.matches()) {
            throw new EdiParseException("Unable to extract id and name for Composite element from line [" + line + "].");
        }
        String id = headerMatcher.group(1);
        String name = headerMatcher.group(2);
        String description = UnCefactDefinitionReader.getValue(reader, "Desc:");
        field.setXmltag(name);
        field.setDocumentation(description);
        line = UnCefactDefinitionReader.readUntilValue(reader);
        while (line != null && line.length() != 0) {
            LinePart linePart = UnCefactDefinitionReader.getLinePart(reader, line);
            if (linePart != null) {
                Component component = new Component();
                component.setRequired(Boolean.valueOf(linePart.isMandatory()));
                UnCefactDefinitionReader.populateComponent(component, components.get(linePart.getId()));
                field.getComponent().add(component);
            }
            line = reader.readLine();
        }
        return id;
    }

    private static void populateComponent(Component toComponent, Component fromComponent) {
        toComponent.setDocumentation(fromComponent.getDocumentation());
        toComponent.setMaxLength(fromComponent.getMaxLength());
        toComponent.setMinLength(fromComponent.getMinLength());
        toComponent.setTruncatable(Boolean.valueOf(true));
        toComponent.setType(fromComponent.getType());
        toComponent.setTypeParameters(fromComponent.getTypeParameters());
        toComponent.setXmltag(fromComponent.getXmltag());
    }

    private static Map<String, Component> readComponents(Reader reader) throws IOException, EdiParseException {
        HashMap<String, Component> datas = new HashMap<String, Component>();
        BufferedReader _reader = new BufferedReader(reader);
        UnCefactDefinitionReader.moveToNextPart(_reader);
        Component component = new Component();
        String id = UnCefactDefinitionReader.populateComponent(_reader, component);
        while (id != null) {
            datas.put(id, component);
            UnCefactDefinitionReader.moveToNextPart(_reader);
            component = new Component();
            id = UnCefactDefinitionReader.populateComponent(_reader, component);
        }
        return datas;
    }

    private static String populateComponent(BufferedReader reader, Component component) throws IOException, EdiParseException {
        String line = UnCefactDefinitionReader.readUntilValue(reader);
        if (line == null) {
            return null;
        }
        Matcher headerMatcher = ELEMENT_HEADER.matcher(line);
        if (!headerMatcher.matches()) {
            throw new EdiParseException("Unable to extract id and name for Data element from line [" + line + "].");
        }
        String id = headerMatcher.group(1);
        String name = headerMatcher.group(2);
        String description = UnCefactDefinitionReader.getValue(reader, "Desc:");
        String repr = UnCefactDefinitionReader.getValue(reader, "Repr:");
        String[] typeAndOccurance = repr.split(DOTS);
        component.setXmltag(name.trim());
        component.setType(UnCefactDefinitionReader.getType(typeAndOccurance));
        component.setMinLength(Integer.valueOf(UnCefactDefinitionReader.getMinLength(typeAndOccurance)));
        component.setMaxLength(Integer.valueOf(UnCefactDefinitionReader.getMaxLength(typeAndOccurance)));
        component.setDocumentation(description);
        return id;
    }

    private static int getMinLength(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return 0;
        }
        if (typeAndOccurance.length == 1) {
            return Integer.valueOf(typeAndOccurance[0].trim().replace("a", "").replace("n", ""));
        }
        return 0;
    }

    private static int getMaxLength(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return 0;
        }
        if (typeAndOccurance.length == 1) {
            return Integer.valueOf(typeAndOccurance[0].trim().replace("a", "").replace("n", ""));
        }
        return Integer.valueOf(typeAndOccurance[1].trim());
    }

    private static String getType(String[] typeAndOccurance) {
        if (typeAndOccurance.length == 0) {
            return "String";
        }
        if (typeAndOccurance[0].trim().equals("n")) {
            return "BigDecimal";
        }
        return "String";
    }

    private static String getValue(BufferedReader reader, String prefix) throws IOException {
        StringBuilder result = new StringBuilder();
        String line = UnCefactDefinitionReader.readUntilValue(reader);
        if ((line = line.trim()).startsWith(prefix)) {
            result.append(line.replace(prefix, ""));
            line = reader.readLine();
            while (line.length() != 0) {
                result.append(line.trim());
                line = reader.readLine();
            }
        }
        return result.toString();
    }

    private static String readUntilValue(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && line.length() == 0) {
            line = reader.readLine();
        }
        return line;
    }

    private static void moveToNextPart(BufferedReader reader) throws IOException {
        String currentLine = "";
        while (currentLine != null && !currentLine.matches(ELEMENT_SEPARATOR)) {
            currentLine = reader.readLine();
        }
    }

    private static LinePart getLinePart(BufferedReader reader, String line) throws IOException {
        LinePart part = null;
        Matcher matcher = WHOLE_DATA_ELEMENT.matcher(line);
        if (matcher.matches()) {
            part = new LinePart(matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7));
        } else {
            matcher = FIRST_DATA_ELEMENT_PART.matcher(line);
            if (matcher.matches()) {
                part = new LinePart(matcher.group(2), matcher.group(3));
                line = reader.readLine();
                matcher = SECOND_DATA_ELEMENT_PART.matcher(line);
                if (matcher.matches()) {
                    part.setDescription(part.getDescription() + " " + matcher.group(1));
                    part.setMandatory(matcher.group(2));
                    part.setType(matcher.group(3));
                    part.setMinOccurance(matcher.group(4), matcher.group(5));
                    part.setMaxOccurance(matcher.group(5));
                }
            }
        }
        return part;
    }

    public static Edimap parse(Reader dataReader, Reader compositeReader, Reader segmentReader) throws IOException, EdiParseException {
        Map<String, Component> datas = UnCefactDefinitionReader.readComponents(dataReader);
        Map<String, Field> composites = UnCefactDefinitionReader.readFields(compositeReader, datas);
        List<Segment> segments = UnCefactDefinitionReader.readSegments(segmentReader, composites, datas);
        Edimap edimap = new Edimap();
        edimap.setSegments(new SegmentGroup());
        edimap.getSegments().getSegments().addAll(segments);
        return edimap;
    }

    private static class LinePart {
        private String id;
        private String description;
        private String type;
        private Integer minOccurance;
        private Integer maxOccurance;
        private boolean isMandatory;

        public LinePart(String id, String description, String mandatory, String type, String minOccurs, String maxOccurs) {
            this.id = id;
            this.description = description;
            this.setMandatory(mandatory);
            this.setType(type);
            this.setMinOccurance(minOccurs, maxOccurs);
            this.setMaxOccurance(maxOccurs);
        }

        private void setMandatory(String mandatory) {
            this.isMandatory = mandatory.equalsIgnoreCase("M");
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setMaxOccurance(String maxOccurs) {
            this.maxOccurance = Integer.valueOf(maxOccurs);
        }

        public void setMinOccurance(String minOccurs, String maxOccurs) {
            this.minOccurance = minOccurs.equals("..") ? 0 : Integer.valueOf(maxOccurs);
        }

        public void setType(String type) {
            this.type = type.equalsIgnoreCase("n") ? "BigDecimal" : "String";
        }

        public LinePart(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public Integer getMinOccurance() {
            return this.minOccurance;
        }

        public Integer getMaxOccurance() {
            return this.maxOccurance;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }
    }
}

