/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.milyn.ect.ConfigReader;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.formats.unedifact.UnCefactDefinitionReader;
import org.milyn.ect.formats.unedifact.UnEdifactMessageReader;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactReader
implements ConfigReader {
    private static final int BUFFER = 2048;
    private static final String INTERCHANGE_DEFINITION = "un-edifact-interchange-definition.xml";
    private boolean useImport;
    private Map<String, byte[]> definitionFiles;
    private Map<String, byte[]> messageFiles;
    private Edimap definitionModel;

    @Override
    public void initialize(InputStream inputStream, boolean useImport) throws IOException, EdiParseException {
        this.useImport = useImport;
        if (!(inputStream instanceof ZipInputStream)) {
            throw new IOException("InputStream should be a ZipInputStream when parsing UnEdifact specification.");
        }
        ZipInputStream zipInputStream = (ZipInputStream)inputStream;
        this.definitionFiles = new HashMap<String, byte[]>();
        this.messageFiles = new HashMap<String, byte[]>();
        UnEdifactReader.readDefinitionEntries(zipInputStream, new ZipDirectoryEntry("eded.", this.definitionFiles), new ZipDirectoryEntry("edcd.", this.definitionFiles), new ZipDirectoryEntry("edsd.", this.definitionFiles), new ZipDirectoryEntry("edmd.", "*", this.messageFiles));
        this.definitionModel = this.parseEDIDefinitionFiles();
        try {
            EdifactModel interchangeEnvelope = new EdifactModel();
            interchangeEnvelope.parseSequence(ClassUtil.getResourceAsStream((String)INTERCHANGE_DEFINITION, this.getClass()));
            this.definitionModel.getSegments().getSegments().addAll(interchangeEnvelope.getEdimap().getSegments().getSegments());
        }
        catch (Exception e) {
            throw new EdiParseException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getMessageNames() {
        return this.messageFiles.keySet();
    }

    @Override
    public Edimap getMappingModelForMessage(String messageName) throws IOException {
        return this.parseEdiMessage(messageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Edimap parseEdiMessage(String messageName) throws IOException {
        byte[] message = this.messageFiles.get(messageName);
        Edimap edimap = null;
        if (message != null) {
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(message));
            try {
                edimap = UnEdifactMessageReader.readMessage(reader, this.useImport, this.definitionModel);
            }
            finally {
                reader.close();
            }
        }
        return edimap;
    }

    @Override
    public Edimap getDefinitionModel() throws IOException {
        if (this.definitionModel.getDescription() == null) {
            Edimap messageEdimap = this.parseEdiMessage(this.messageFiles.keySet().iterator().next());
            this.definitionModel.getSegments().setXmltag(messageEdimap.getDescription().getName() + "-Definition");
            this.definitionModel.setDescription(messageEdimap.getDescription());
            this.definitionModel.setDelimiters(messageEdimap.getDelimiters());
        }
        return this.definitionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Edimap parseEDIDefinitionFiles() throws IOException, EdiParseException {
        Edimap edifactModel;
        Reader dataISR = null;
        Reader compositeISR = null;
        Reader segmentISR = null;
        try {
            dataISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("eded.")));
            compositeISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edcd.")));
            segmentISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edsd.")));
            edifactModel = UnCefactDefinitionReader.parse(dataISR, compositeISR, segmentISR);
        }
        finally {
            if (dataISR != null) {
                dataISR.close();
            }
            if (compositeISR != null) {
                compositeISR.close();
            }
            if (segmentISR != null) {
                segmentISR.close();
            }
        }
        return edifactModel;
    }

    private static void readDefinitionEntries(ZipInputStream folderZip, ZipDirectoryEntry ... entries) throws IOException {
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            for (ZipDirectoryEntry entry : entries) {
                int size;
                if (!fileEntry.getName().toLowerCase().startsWith(entry.getDirectory())) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    baos.write(bytes, 0, size);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
                UnEdifactReader.readZipEntry(entry.getEntries(), zipInputStream, entry.getFile());
                zipInputStream.close();
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
    }

    private static boolean readZipEntry(Map<String, byte[]> files, ZipInputStream folderZip, String entry) throws IOException {
        boolean result = false;
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            if (fileEntry.getName().toLowerCase().startsWith(entry) || entry.equals("*")) {
                int size;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    baos.write(bytes, 0, size);
                }
                result = true;
                if (entry.equals("*")) {
                    if (fileEntry.getName().indexOf(95) != -1) {
                        files.put(fileEntry.getName().substring(0, fileEntry.getName().indexOf(95)), baos.toByteArray());
                    }
                } else {
                    files.put(entry, baos.toByteArray());
                    break;
                }
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipDirectoryEntry {
        private String directory;
        private String file;
        private Map<String, byte[]> entries;

        private ZipDirectoryEntry(String directory, Map<String, byte[]> entries) {
            this(directory, directory, entries);
        }

        public ZipDirectoryEntry(String directory, String file, Map<String, byte[]> entries) {
            this.directory = directory;
            this.file = file;
            this.entries = entries;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getFile() {
            return this.file;
        }

        public Map<String, byte[]> getEntries() {
            return this.entries;
        }
    }
}

