/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.ZipInputStream;
import org.milyn.ect.EdiConvertionTool;
import org.milyn.ect.EdiParseException;

public class ECTUnEdifactExecutor {
    private File unEdifactZip;
    private File outFile;
    private String messageName;

    public void execute() throws EdiParseException {
        FileWriter writer;
        ZipInputStream zipInputStream;
        FileInputStream fileInputStream;
        this.assertMandatoryProperty(this.unEdifactZip, "unEdifactZip");
        this.assertMandatoryProperty(this.outFile, "outFile");
        this.assertMandatoryProperty(this.messageName, "messageName");
        if (!this.unEdifactZip.exists()) {
            throw new EdiParseException("Specified EDI Mapping Model file '" + this.unEdifactZip.getAbsoluteFile() + "' does not exist.");
        }
        if (this.unEdifactZip.exists() && this.unEdifactZip.isDirectory()) {
            throw new EdiParseException("Specified EDI Mapping Model file '" + this.unEdifactZip.getAbsoluteFile() + "' exists, but is a directory.  Must be an EDI Mapping Model file.");
        }
        try {
            fileInputStream = new FileInputStream(this.unEdifactZip);
            zipInputStream = new ZipInputStream(fileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new EdiParseException("Error opening zip file containing the Un/Edifact specification '" + this.unEdifactZip.getAbsoluteFile() + "'.", e);
        }
        try {
            writer = new FileWriter(this.outFile);
        }
        catch (IOException e) {
            throw new EdiParseException("Error opening writer for outFile '" + this.outFile.getAbsoluteFile() + "'.", e);
        }
        try {
            EdiConvertionTool.convertUnEdifact(zipInputStream, this.messageName, writer);
        }
        catch (Exception e) {
            throw new EdiParseException("Error parsing the Un/Edifact specification '" + this.unEdifactZip.getAbsoluteFile() + "'.", e);
        }
        finally {
            try {
                zipInputStream.close();
                fileInputStream.close();
            }
            catch (IOException e) {
                throw new EdiParseException("Error closing the zip file containing the Un/Edifact specification '" + this.unEdifactZip.getAbsoluteFile() + "'.", e);
            }
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new EdiParseException("Error closing the outFile '" + this.outFile.getAbsoluteFile() + "'.", e);
            }
        }
    }

    public void setUnEdifactZip(File unEdifactZip) {
        this.unEdifactZip = unEdifactZip;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    private void assertMandatoryProperty(Object obj, String name) {
        if (obj == null) {
            throw new EdiParseException("Mandatory EJC property '" + name + "' + not specified.");
        }
    }
}

