/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactMessageReader {
    public static final String INTERCHANGE_NAMESPACE = "envelope";
    private static final String MESSAGE_DEFINITION = "[\\d\\. ]*MESSAGE DEFINITION";
    private static final String MESSAGE_DEFINITION_START = "^(\\d{4}) *(.*)";
    private static final String MESSAGE_DEFINITION_END = "([\\d\\.]* *Segment index .*)";
    private static final Pattern MESSAGE_TYPE = Pattern.compile(".*Message Type *: *(\\w*)");
    private static final Pattern MESSAGE_RELEASE = Pattern.compile(".*Release *: *(\\w*)");
    private static final Pattern MESSAGE_AGENCY = Pattern.compile(".*Contr. Agency *: *(\\w*)");
    private static final Pattern MESSAGE_VERSION = Pattern.compile(".*Version *: *(\\w*)");
    private static final String SEGMENT_TABLE = "[\\d\\. ]*Segment table";
    private static final String SEGMENT_TABLE_HEADER = "Pos *Tag *Name *S *R.*";
    private static String SEGMENT_REGULAR = "(\\d{4}) *(\\w{3}) *([\\w /]*) *(M|C) *(\\d*)[ \\|]*";
    private static String SEGMENT_GROUP_START = "(\\d{4}) *-* *(Segment group \\d*) *-* *(C|M) *(\\d*)[-+|]*";
    private static String SEGMENT_GROUP_END = "(\\d{4}) *(\\w{3}) *([\\w /]*) *(C|M) *(\\d*)([-|\\+]*)";
    private static final String NEW_LINE = "\n";
    private static final String LEGAL_MESSAGE = " *UN/EDIFACT";
    private static final String MESSAGE_NAME = "UN-EDIFACT";
    private static final String DELIMITER_SEGMENT = "&#39;";
    private static final String DELIMITER_COMPOSITE = "+";
    private static final String DELIMITER_SUB_COMPOSITE = "~";
    private static final String DELIMITER_DATA = ":";
    private static final String ESCAPE = "?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Edimap readMessage(Reader reader, boolean isSplitIntoImport, Edimap definitionModel) throws IOException {
        Edimap edimap = null;
        BufferedReader breader = null;
        try {
            breader = new BufferedReader(reader);
            if (!UnEdifactMessageReader.legalMessage(breader)) {
                Edimap edimap2 = null;
                return edimap2;
            }
            String type = UnEdifactMessageReader.getValue(breader, MESSAGE_TYPE);
            String version = UnEdifactMessageReader.getValue(breader, MESSAGE_VERSION);
            String release = UnEdifactMessageReader.getValue(breader, MESSAGE_RELEASE);
            String agency = UnEdifactMessageReader.getValue(breader, MESSAGE_AGENCY);
            edimap = new Edimap();
            SegmentGroup rootGroup = new SegmentGroup();
            rootGroup.setXmltag(type);
            edimap.setSegments(rootGroup);
            Delimiters delimiters = new Delimiters();
            delimiters.setSegment(DELIMITER_SEGMENT);
            delimiters.setField(DELIMITER_COMPOSITE);
            delimiters.setComponent(DELIMITER_SUB_COMPOSITE);
            delimiters.setSubComponent(DELIMITER_DATA);
            delimiters.setEscape(ESCAPE);
            edimap.setDelimiters(delimiters);
            edimap.setDescription(new Description());
            edimap.getDescription().setName(MESSAGE_NAME);
            edimap.getDescription().setVersion(version + release);
            Map<String, Segment> segmentDefinitions = null;
            if (isSplitIntoImport) {
                Import ediImport = new Import();
                ediImport.setNamespace(agency);
                ediImport.setResource("TODO");
                edimap.getImports().add(ediImport);
            } else {
                segmentDefinitions = UnEdifactMessageReader.getSegmentDefinitions(definitionModel);
            }
            Map<String, String> definitions = UnEdifactMessageReader.parseMessageDefinition(breader);
            UnEdifactMessageReader.parseMessageStructure(breader, rootGroup, definitions, agency, isSplitIntoImport, segmentDefinitions);
        }
        finally {
            if (breader != null) {
                breader.close();
            }
        }
        return edimap;
    }

    private static Map<String, Segment> getSegmentDefinitions(Edimap definitionModel) {
        HashMap<String, Segment> result = new HashMap<String, Segment>();
        for (SegmentGroup segmentGroup : definitionModel.getSegments().getSegments()) {
            result.put(segmentGroup.getSegcode(), (Segment)segmentGroup);
        }
        return result;
    }

    private static boolean legalMessage(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        return line.matches(LEGAL_MESSAGE);
    }

    private static void parseMessageStructure(BufferedReader reader, SegmentGroup group, Map<String, String> definitions, String agency, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions) throws IOException {
        String line = reader.readLine();
        while (!line.matches(SEGMENT_TABLE)) {
            line = reader.readLine();
        }
        while (!line.matches(SEGMENT_TABLE_HEADER)) {
            line = reader.readLine();
        }
        UnEdifactMessageReader.parseNextSegment(reader, group, definitions, agency, isSplitIntoImport, segmentDefinitions);
    }

    private static Map<String, String> parseMessageDefinition(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (!line.matches(MESSAGE_DEFINITION)) {
            line = reader.readLine();
        }
        while (!line.matches(MESSAGE_DEFINITION_START)) {
            line = reader.readLine();
        }
        HashMap<String, String> definitions = new HashMap<String, String>();
        while (!line.matches(MESSAGE_DEFINITION_END)) {
            if (line.matches(MESSAGE_DEFINITION_START)) {
                Pattern pattern = Pattern.compile(MESSAGE_DEFINITION_START);
                Matcher matcher = pattern.matcher(line);
                matcher.matches();
                String id = matcher.group(1);
                StringBuilder definition = new StringBuilder();
                definition.append(matcher.group(2)).append(NEW_LINE);
                line = reader.readLine();
                while (!line.matches(MESSAGE_DEFINITION_START) && !line.matches(MESSAGE_DEFINITION_END)) {
                    definition.append(line).append(NEW_LINE);
                    line = reader.readLine();
                }
                definitions.put(id, definition.toString());
                continue;
            }
            line = reader.readLine();
        }
        return definitions;
    }

    private static int parseNextSegment(BufferedReader reader, SegmentGroup parentGroup, Map<String, String> definitions, String agency, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            Segment segment;
            Matcher matcher;
            if (line.matches(SEGMENT_REGULAR)) {
                matcher = Pattern.compile(SEGMENT_REGULAR).matcher(line);
                matcher.matches();
                segment = UnEdifactMessageReader.createSegment(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), definitions, agency, isSplitIntoImport, segmentDefinitions);
                parentGroup.getSegments().add(segment);
            } else if (line.matches(SEGMENT_GROUP_START)) {
                matcher = Pattern.compile(SEGMENT_GROUP_START).matcher(line);
                matcher.matches();
                SegmentGroup group = UnEdifactMessageReader.createGroup(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), definitions);
                parentGroup.getSegments().add(group);
                int result = UnEdifactMessageReader.parseNextSegment(reader, group, definitions, agency, isSplitIntoImport, segmentDefinitions);
                if (result != 0) {
                    return result - 1;
                }
            } else if (line.matches(SEGMENT_GROUP_END)) {
                matcher = Pattern.compile(SEGMENT_GROUP_END).matcher(line);
                matcher.matches();
                segment = UnEdifactMessageReader.createSegment(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), definitions, agency, isSplitIntoImport, segmentDefinitions);
                parentGroup.getSegments().add(segment);
                return UnEdifactMessageReader.extractPlusCharacter(matcher.group(6)).length() - 1;
            }
            line = reader.readLine();
        }
        return 0;
    }

    private static String extractPlusCharacter(String value) {
        return value.replaceAll("[^\\+]", "");
    }

    private static SegmentGroup createGroup(String id, String name, String mandatory, String maxOccurance, Map<String, String> definitions) {
        SegmentGroup group = new SegmentGroup();
        group.setXmltag(name.trim());
        group.setDocumentation(definitions.get(id).trim());
        group.setMinOccurs(Integer.valueOf(mandatory.equals("M") ? 1 : 0));
        group.setMaxOccurs(Integer.valueOf(maxOccurance));
        return group;
    }

    private static Segment createSegment(String id, String segcode, String description, String mandatory, String maxOccurance, Map<String, String> definitions, String agency, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions) {
        Segment segment = new Segment();
        segment.setSegcode(segcode);
        if (isSplitIntoImport) {
            segment.setSegref(agency + DELIMITER_DATA + segcode);
        } else {
            Segment importedSegment = segmentDefinitions.get(segcode);
            segment.getFields().addAll(importedSegment.getFields());
            if (importedSegment.getSegments().size() > 0) {
                segment.getSegments().addAll(importedSegment.getSegments());
            }
        }
        segment.setXmltag(description.trim());
        segment.setDocumentation(definitions.get(id).trim());
        segment.setMinOccurs(Integer.valueOf(mandatory.equals("M") ? 1 : 0));
        segment.setMaxOccurs(Integer.valueOf(maxOccurance));
        return segment;
    }

    private static String getValue(BufferedReader reader, Pattern pattern) throws IOException {
        String line = reader.readLine();
        Matcher matcher = pattern.matcher(line);
        while (!matcher.matches()) {
            line = reader.readLine();
            matcher = pattern.matcher(line);
        }
        return matcher.group(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Edimap test() throws IOException {
        FileInputStream in = null;
        Reader reader = null;
        try {
            in = new FileInputStream("C:\\Documents and Settings\\bardl\\Skrivbord\\d08a\\edmd\\INVOIC_D.08A");
            reader = new InputStreamReader(in);
            Edimap edimap = UnEdifactMessageReader.readMessage(reader, false, null);
            return edimap;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

