/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.ecore;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.ValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECoreConversionUtils {
    private static final EDataType[] ETYPES = new EDataType[]{XMLTypePackage.Literals.STRING, XMLTypePackage.Literals.LONG, XMLTypePackage.Literals.DECIMAL, XMLTypePackage.Literals.FLOAT};
    private static ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
    private static final Log log = LogFactory.getLog(ECoreConversionUtils.class);

    public static EClass segmentToEClass(Segment segment) {
        EClass clazz = ECoreConversionUtils.segmentGroupToEClass((SegmentGroup)segment);
        ECoreConversionUtils.annotate((EModelElement)clazz, "segcode", segment.getSegcode());
        ECoreConversionUtils.annotate((EModelElement)clazz, "segcodePattern", segment.getSegcodePattern().toString());
        ECoreConversionUtils.annotate((EModelElement)clazz, "truncable", String.valueOf(segment.isTruncatable()));
        ECoreConversionUtils.annotate((EModelElement)clazz, "ignoreUnmappedFields", String.valueOf(segment.isIgnoreUnmappedFields()));
        ECoreConversionUtils.annotate((EModelElement)clazz, "description", segment.getDescription());
        ECoreConversionUtils.annotate((EModelElement)clazz, "type", "segment");
        return clazz;
    }

    public static EPackage mappingModelToEPackage(Edimap mapModel) {
        EPackage pkg = EcoreFactory.eINSTANCE.createEPackage();
        Description desc = mapModel.getDescription();
        pkg.setName(desc.getName().toLowerCase());
        pkg.setNsPrefix(desc.getName().toLowerCase());
        pkg.setNsURI(desc.getNamespace());
        if (mapModel.getSrc() != null) {
            ECoreConversionUtils.annotate((EModelElement)pkg, "src", mapModel.getSrc().toASCIIString());
        }
        ECoreConversionUtils.annotate((EModelElement)pkg, "description.name", mapModel.getDescription().getName());
        ECoreConversionUtils.annotate((EModelElement)pkg, "description.version", mapModel.getDescription().getVersion());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.segment", mapModel.getDelimiters().getSegment());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.component", mapModel.getDelimiters().getComponent());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.field", mapModel.getDelimiters().getField());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.fieldRepeat", mapModel.getDelimiters().getFieldRepeat());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.escape", mapModel.getDelimiters().getEscape());
        ECoreConversionUtils.annotate((EModelElement)pkg, "delimeters.ignoreCLRF", String.valueOf(mapModel.getDelimiters().ignoreCRLF()));
        return pkg;
    }

    public static EReference segmentToEReference(Segment segment, EClass refClass) {
        EReference reference = ECoreConversionUtils.segmentGroupToEReference((SegmentGroup)segment, refClass);
        ECoreConversionUtils.annotate((EModelElement)reference, "type", "segment");
        ECoreConversionUtils.annotate((EModelElement)reference, "segcode", segment.getSegcode());
        String name = segment.getSegcode();
        char lastChar = reference.getName().charAt(reference.getName().length() - 1);
        if (Character.isDigit(lastChar)) {
            name = name + lastChar;
        }
        reference.setName(name);
        return reference;
    }

    public static EClass segmentGroupToEClass(SegmentGroup grp) {
        EClass clazz = EcoreFactory.eINSTANCE.createEClass();
        clazz.setName(ECoreConversionUtils.toJavaName(grp.getXmltag(), true));
        ECoreConversionUtils.addMappingInformation(clazz, (MappingNode)grp);
        return clazz;
    }

    private static void addMappingInformation(EClass clazz, MappingNode node) {
        if (node.getDocumentation() != null) {
            ECoreConversionUtils.annotate((EModelElement)clazz, "documentation", node.getDocumentation());
        }
        metadata.setName((EClassifier)clazz, clazz.getName());
        metadata.setContentKind(clazz, 4);
    }

    private static void addMappingInformation(EStructuralFeature ref, MappingNode node) {
        metadata.setName(ref, node.getXmltag());
        metadata.setFeatureKind(ref, 4);
        ECoreConversionUtils.setTargetNamespace(ref);
    }

    private static void annotate(EModelElement element, String key, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            EAnnotation annotation = element.getEAnnotation("smooks-mapping-data");
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("smooks-mapping-data");
                element.getEAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)key, (Object)value);
        }
    }

    public static EReference segmentGroupToEReference(SegmentGroup grp, EClass refClass) {
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        reference.setContainment(true);
        reference.setName(ECoreConversionUtils.toJavaName(grp.getXmltag(), false));
        reference.setEType((EClassifier)refClass);
        reference.setLowerBound(grp.getMinOccurs());
        reference.setUpperBound(grp.getMaxOccurs());
        ECoreConversionUtils.addMappingInformation((EStructuralFeature)reference, (MappingNode)grp);
        ECoreConversionUtils.annotate((EModelElement)reference, "minOccurs", String.valueOf(grp.getMinOccurs()));
        ECoreConversionUtils.annotate((EModelElement)reference, "maxOccurs", String.valueOf(grp.getMaxOccurs()));
        ECoreConversionUtils.annotate((EModelElement)reference, "type", "group");
        ECoreConversionUtils.annotate((EModelElement)reference, "segcode", grp.getSegcode());
        return reference;
    }

    public static EAttribute fieldToEAttribute(Field field) {
        if (!field.getComponents().isEmpty()) {
            throw new IllegalArgumentException("Can't convert field with components to EAttribute, use fieldToEReference");
        }
        EAttribute attr = EcoreFactory.eINSTANCE.createEAttribute();
        attr.setName(ECoreConversionUtils.toJavaName(field.getXmltag(), false));
        attr.setLowerBound(field.isRequired() ? 1 : 0);
        attr.setUpperBound(1);
        if (field.getTypeClass() != null) {
            attr.setEType(ECoreConversionUtils.toEType(field.getTypeClass()));
        } else {
            log.warn((Object)("Field " + field.getXmltag() + " has no type! Setting it's type to String"));
            attr.setEType((EClassifier)XMLTypePackage.Literals.STRING);
        }
        ECoreConversionUtils.addMappingInformation((EStructuralFeature)attr, (MappingNode)field);
        ECoreConversionUtils.annotateField(field, (EModelElement)attr);
        return attr;
    }

    private static void annotateField(Field field, EModelElement attr) {
        ECoreConversionUtils.annotate(attr, "truncable", String.valueOf(field.isTruncatable()));
        ECoreConversionUtils.annotate(attr, "required", String.valueOf(field.isRequired()));
        ECoreConversionUtils.annotate(attr, "type", "field");
        ECoreConversionUtils.annotateValueNode(attr, (ValueNode)field);
    }

    public static EReference fieldToEReference(Field field, Map<String, EClass> classes) {
        EClass newClass = ECoreConversionUtils.fieldToEClass(field);
        if (!classes.containsKey(newClass.getName())) {
            classes.put(newClass.getName(), newClass);
        } else {
            newClass = classes.get(newClass.getName());
        }
        for (Component component : field.getComponents()) {
            EStructuralFeature attribute = ECoreConversionUtils.componentToEAttribute(component);
            if (newClass.getEStructuralFeature(attribute.getName()) != null) continue;
            newClass.getEStructuralFeatures().add((Object)attribute);
        }
        EReference result = EcoreFactory.eINSTANCE.createEReference();
        result.setContainment(true);
        result.setName(ECoreConversionUtils.toJavaName(field.getXmltag(), false));
        result.setLowerBound(field.isRequired() ? 1 : 0);
        result.setUpperBound(1);
        result.setEType((EClassifier)newClass);
        ECoreConversionUtils.annotateField(field, (EModelElement)result);
        ECoreConversionUtils.addMappingInformation((EStructuralFeature)result, (MappingNode)field);
        return result;
    }

    private static EStructuralFeature componentToEAttribute(Component component) {
        if (!component.getSubComponents().isEmpty()) {
            throw new IllegalArgumentException("Sub-components are not supported yet for component " + component.getXmltag());
        }
        EAttribute result = EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(ECoreConversionUtils.toJavaName(component.getXmltag(), false));
        result.setLowerBound(component.isRequired() ? 1 : 0);
        result.setUpperBound(1);
        result.setEType(ECoreConversionUtils.toEType(component.getTypeClass()));
        ECoreConversionUtils.annotate((EModelElement)result, "truncable", String.valueOf(component.isTruncatable()));
        ECoreConversionUtils.annotate((EModelElement)result, "required", String.valueOf(component.isRequired()));
        ECoreConversionUtils.annotate((EModelElement)result, "type", "component");
        ECoreConversionUtils.annotateValueNode((EModelElement)result, (ValueNode)component);
        ECoreConversionUtils.addMappingInformation((EStructuralFeature)result, (MappingNode)component);
        return result;
    }

    private static EClassifier toEType(Class<?> typeClass) {
        if (typeClass == null) {
            typeClass = String.class;
        }
        for (EDataType type : ETYPES) {
            if (type.getInstanceClass() != typeClass) continue;
            return type;
        }
        throw new IllegalArgumentException("Type for type class " + typeClass + " is not supported");
    }

    private static EClass fieldToEClass(Field field) {
        String classifierName = ECoreConversionUtils.toJavaName(field.getXmltag(), true);
        if (field.getNodeTypeRef() != null) {
            classifierName = classifierName + "_" + field.getNodeTypeRef();
        }
        EClass newClass = EcoreFactory.eINSTANCE.createEClass();
        newClass.setName(classifierName);
        ECoreConversionUtils.addMappingInformation(newClass, (MappingNode)field);
        ECoreConversionUtils.annotate((EModelElement)newClass, "type", "field");
        ECoreConversionUtils.annotateValueNode((EModelElement)newClass, (ValueNode)field);
        return newClass;
    }

    private static void annotateValueNode(EModelElement element, ValueNode valueNode) {
        ECoreConversionUtils.annotate(element, "datatype", valueNode.getDataType());
        ECoreConversionUtils.annotate(element, "maxLength", String.valueOf(valueNode.getMaxLength()));
        ECoreConversionUtils.annotate(element, "minLength", String.valueOf(valueNode.getMinLength()));
        if (valueNode.getDecoder() != null) {
            ECoreConversionUtils.annotate(element, "decoder", valueNode.getDecoder().getClass().getCanonicalName());
        } else {
            ECoreConversionUtils.annotate(element, "decoder", "");
        }
    }

    public static String toJavaName(String name, boolean className) {
        name = name.replaceAll("__", "_");
        StringBuilder result = new StringBuilder();
        boolean cap = className;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if ('_' == ch || '.' == ch) {
                cap = true;
                continue;
            }
            if (cap) {
                result.append(Character.toUpperCase(ch));
                cap = false;
                continue;
            }
            result.append(Character.toLowerCase(ch));
        }
        return result.toString();
    }

    public static EClass createDocumentRoot(EClass rootClass) {
        EClass clazz = EcoreFactory.eINSTANCE.createEClass();
        clazz.setName("DocumentRoot");
        metadata.setDocumentRoot(clazz);
        if (rootClass != null) {
            EReference reference = EcoreFactory.eINSTANCE.createEReference();
            clazz.getEStructuralFeatures().add((Object)reference);
            reference.setEType((EClassifier)rootClass);
            reference.setName(metadata.getName((EClassifier)rootClass));
            metadata.setFeatureKind((EStructuralFeature)reference, 4);
            ECoreConversionUtils.setTargetNamespace((EStructuralFeature)reference);
            reference.setContainment(true);
        }
        return clazz;
    }

    private static void setTargetNamespace(EStructuralFeature element) {
        EAnnotation eAnnotation = element.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        eAnnotation.getDetails().put((Object)"namespace", (Object)"##targetNamespace");
    }
}

