/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.milyn.archive.Archive;
import org.milyn.assertion.AssertArgument;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.EdiSpecificationReader;
import org.milyn.ect.ecore.ECoreGenerator;
import org.milyn.ect.ecore.SchemaConverter;
import org.milyn.ect.formats.unedifact.UnEdifactSpecificationReader;
import org.milyn.edisax.interchange.EdiDirectory;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdiConvertionTool {
    private static final Log logger = LogFactory.getLog(EdiConvertionTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromUnEdifactSpec(ZipInputStream specification, ZipOutputStream modelSetOutStream, String urn, boolean useShortName) throws IOException {
        try {
            EdiConvertionTool.fromSpec((EdiSpecificationReader)new UnEdifactSpecificationReader(specification, true, useShortName), modelSetOutStream, urn);
        }
        finally {
            specification.close();
        }
    }

    public static Archive fromUnEdifactSpec(File specification, String urn) throws IOException {
        return EdiConvertionTool.fromUnEdifactSpec(specification, urn, null);
    }

    public static Archive fromUnEdifactSpec(File specification, String urn, String ... messages) throws IOException {
        ZipInputStream definitionZipStream;
        try {
            definitionZipStream = new ZipInputStream(new FileInputStream(specification));
        }
        catch (FileNotFoundException e) {
            throw new EdiParseException("Error opening zip file containing the Un/Edifact specification '" + specification.getAbsoluteFile() + "'.", e);
        }
        return EdiConvertionTool.createArchive(new UnEdifactSpecificationReader(definitionZipStream, true), urn, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromSpec(EdiSpecificationReader ediSpecificationReader, ZipOutputStream modelSetOutStream, String urn) throws IOException {
        AssertArgument.isNotNull((Object)ediSpecificationReader, (String)"ediSpecificationReader");
        AssertArgument.isNotNull((Object)modelSetOutStream, (String)"modelSetOutStream");
        try {
            Archive archive = EdiConvertionTool.createArchive(ediSpecificationReader, urn, new String[0]);
            archive.toOutputStream(modelSetOutStream);
        }
        catch (Throwable t) {
            logger.fatal((Object)("Error while generating EDI Mapping Model archive for '" + urn + "'."), t);
        }
        finally {
            modelSetOutStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromUnEdifactSpec(ZipInputStream specification, File modelSetOutFolder, String urn, boolean useShortName) throws IOException {
        try {
            EdiConvertionTool.fromSpec((EdiSpecificationReader)new UnEdifactSpecificationReader(specification, true, useShortName), modelSetOutFolder, urn);
        }
        finally {
            specification.close();
        }
    }

    public static void fromSpec(EdiSpecificationReader ediSpecificationReader, File modelSetOutFolder, String urn) throws IOException {
        AssertArgument.isNotNull((Object)ediSpecificationReader, (String)"ediSpecificationReader");
        AssertArgument.isNotNull((Object)modelSetOutFolder, (String)"modelSetOutFolder");
        Archive archive = EdiConvertionTool.createArchive(ediSpecificationReader, urn, new String[0]);
        archive.toFileSystem(modelSetOutFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Archive createArchive(EdiSpecificationReader ediSpecificationReader, String urn, String ... messages) throws IOException {
        Archive archive = new Archive();
        StringBuilder modelListBuilder = new StringBuilder();
        StringWriter messageEntryWriter = new StringWriter();
        String pathPrefix = urn.replace(".", "_").replace(":", "/");
        EdiDirectory ediDirectory = ediSpecificationReader.getEdiDirectory(messages);
        EdiConvertionTool.addModel(ediDirectory.getCommonModel(), pathPrefix, modelListBuilder, messageEntryWriter, archive);
        for (Edimap messageModel : ediDirectory.getMessageModels()) {
            EdiConvertionTool.addModel(messageModel, pathPrefix, modelListBuilder, messageEntryWriter, archive);
        }
        Set<EPackage> packages = new ECoreGenerator().generatePackages(ediDirectory);
        String pluginID = "org.milyn.edi.unedifact.unknown";
        if (urn.lastIndexOf(58) > 0) {
            pluginID = urn.substring(0, urn.lastIndexOf(58)).replace(':', '.').toLowerCase();
        }
        Archive schemas = SchemaConverter.INSTANCE.createArchive(packages, pluginID, pathPrefix);
        archive.merge(schemas);
        archive.addEntry("META-INF/services/org/smooks/edi/mapping-model.lst", modelListBuilder.toString());
        archive.addEntry("META-INF/services/org/smooks/edi/urn", urn);
        Properties interchangeProperties = ediSpecificationReader.getInterchangeProperties();
        ByteArrayOutputStream propertiesOutStream = new ByteArrayOutputStream();
        try {
            interchangeProperties.store(propertiesOutStream, "UN/EDIFACT Interchange Properties");
            propertiesOutStream.flush();
            archive.addEntry("META-INF/services/org/smooks/edi/interchange.properties", propertiesOutStream.toByteArray());
        }
        finally {
            propertiesOutStream.close();
        }
        return archive;
    }

    private static void addModel(Edimap model, String pathPrefix, StringBuilder modelListBuilder, StringWriter messageEntryWriter, Archive archive) throws IOException {
        Description modelDesc = model.getDescription();
        String messageEntryPath = pathPrefix + "/" + modelDesc.getName() + ".xml";
        messageEntryWriter.getBuffer().setLength(0);
        model.write((Writer)messageEntryWriter);
        archive.addEntry(messageEntryPath, messageEntryWriter.toString());
        modelListBuilder.append("/" + messageEntryPath);
        modelListBuilder.append("!" + modelDesc.getName());
        modelListBuilder.append("!" + modelDesc.getVersion());
        modelListBuilder.append("!" + modelDesc.getNamespace());
        modelListBuilder.append("\n");
    }

    public static void removeDuplicateSegments(SegmentGroup segmentGroup) {
        List segments;
        if (segmentGroup instanceof Segment) {
            EdiConvertionTool.removeDuplicateFields(((Segment)segmentGroup).getFields());
        }
        if ((segments = segmentGroup.getSegments()) != null) {
            EdiConvertionTool.removeDuplicateMappingNodes(segments);
            for (SegmentGroup childSegmentGroup : segments) {
                EdiConvertionTool.removeDuplicateSegments(childSegmentGroup);
            }
        }
    }

    private static void removeDuplicateFields(List<Field> fields) {
        if (fields != null && !fields.isEmpty()) {
            EdiConvertionTool.removeDuplicateMappingNodes(fields);
            for (Field field : fields) {
                EdiConvertionTool.removeDuplicateComponents(field.getComponents());
            }
        }
    }

    private static void removeDuplicateComponents(List<Component> components) {
        if (components != null && !components.isEmpty()) {
            EdiConvertionTool.removeDuplicateMappingNodes(components);
            for (Component component : components) {
                EdiConvertionTool.removeDuplicateMappingNodes(component.getSubComponents());
            }
        }
    }

    private static void removeDuplicateMappingNodes(List mappingNodes) {
        if (mappingNodes == null || mappingNodes.isEmpty()) {
            return;
        }
        Set<String> nodeNames = EdiConvertionTool.getMappingNodeNames(mappingNodes);
        if (nodeNames.size() < mappingNodes.size()) {
            for (String nodeName : nodeNames) {
                int nodeCount = EdiConvertionTool.getMappingNodeCount(mappingNodes, nodeName);
                if (nodeCount <= 1) continue;
                EdiConvertionTool.removeDuplicateMappingNodes(mappingNodes, nodeName);
            }
        }
    }

    private static void removeDuplicateMappingNodes(List mappingNodes, String nodeName) {
        int tagIndex = 1;
        for (Object mappingNodeObj : mappingNodes) {
            MappingNode mappingNode = (MappingNode)mappingNodeObj;
            String xmlTag = mappingNode.getXmltag();
            if (xmlTag == null || !xmlTag.equals(nodeName)) continue;
            mappingNode.setXmltag(xmlTag + "_-_-" + tagIndex);
            ++tagIndex;
        }
    }

    private static Set<String> getMappingNodeNames(List mappingNodes) {
        LinkedHashSet<String> nodeNames = new LinkedHashSet<String>();
        for (Object mappingNode : mappingNodes) {
            String xmlTag = ((MappingNode)mappingNode).getXmltag();
            if (xmlTag == null) continue;
            nodeNames.add(xmlTag);
        }
        return nodeNames;
    }

    private static int getMappingNodeCount(List mappingNodes, String nodeName) {
        int nodeCount = 0;
        for (Object mappingNode : mappingNodes) {
            String xmlTag = ((MappingNode)mappingNode).getXmltag();
            if (xmlTag == null || !xmlTag.equals(nodeName)) continue;
            ++nodeCount;
        }
        return nodeCount;
    }
}

