/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.zip.ZipInputStream;
import org.milyn.archive.Archive;
import org.milyn.archive.ArchiveClassLoader;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.util.IllegalNameException;
import org.milyn.ejc.BeanWriter;
import org.milyn.ejc.BindingWriter;
import org.milyn.ejc.ClassModel;
import org.milyn.ejc.EJC;
import org.milyn.io.StreamUtils;
import org.milyn.test.ant.AntRunner;
import org.xml.sax.SAXException;

public class EJCTestUtil {
    public static final String ORG_SMOOKS_EJC_TEST = "org.smooks.ejc.test";

    public static void dumpModel(InputStream mappingModel) throws EDIConfigurationException, ClassNotFoundException, IOException, SAXException, IllegalNameException {
        EJC ejc = new EJC();
        ClassModel model = ejc.compile(mappingModel, ORG_SMOOKS_EJC_TEST);
        PrintWriter writer = new PrintWriter(System.out);
        BeanWriter.writeBeans((ClassModel)model, (Writer)writer);
        BindingWriter.writeBindingConfig((ClassModel)model, (Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Archive buildModelArchive(InputStream mappingModel, String modelJavaPackage) throws EDIConfigurationException, ClassNotFoundException, IOException, SAXException, IllegalNameException {
        BeanWriter.setGenerateFromEDINR((boolean)true);
        try {
            AntRunner antRunner = new AntRunner("build.xml", new String[0]);
            EJC ejc = new EJC();
            antRunner.run("delete");
            ejc.compile(mappingModel, modelJavaPackage, "./target/ejc/src");
            antRunner.run("compile");
            Archive archive = new Archive(new ZipInputStream(new FileInputStream("./target/ejc/ejc.jar")));
            return archive;
        }
        finally {
            BeanWriter.setGenerateFromEDINR((boolean)false);
        }
    }

    public static void testModel(String ediMappingModelFile, String ediMessageFile, String factoryClassName) throws EDIConfigurationException, IOException, SAXException, IllegalNameException {
        EJCTestUtil.testModel(ediMappingModelFile, ediMessageFile, factoryClassName, false);
    }

    public static void testModel(String ediMappingModelFile, String ediMessageFile, String factoryClassName, boolean dump) throws EDIConfigurationException, IOException, SAXException, IllegalNameException {
        Class callerClass = EJCTestUtil.getCallerClass();
        if (callerClass == null) {
            throw new IllegalStateException("Failed to resolve caller class.");
        }
        InputStream mappingModel = callerClass.getResourceAsStream(ediMappingModelFile);
        EJCTestUtil.testModel(ediMessageFile, mappingModel, factoryClassName, dump, callerClass);
    }

    public static void testModel(String ediMessageFile, InputStream mappingModelStream, String factoryClassName, boolean dump, Class callerClass) throws IOException, SAXException, IllegalNameException {
        Archive archive = null;
        try {
            archive = EJCTestUtil.buildModelArchive(mappingModelStream, ORG_SMOOKS_EJC_TEST);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception building model archive: " + e.getMessage());
        }
        EJCTestUtil.testModel(archive, ediMessageFile, factoryClassName, dump, callerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testModel(Archive archive, String ediMessageFile, String factoryClassName, boolean dump, Class callerClass) throws IOException {
        ArchiveClassLoader classLoader = new ArchiveClassLoader(archive);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        try {
            EJCTestUtil.testModel(ediMessageFile, factoryClassName, dump);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader.getParent());
        }
    }

    public static void testModel(String ediMessageFile, String factoryClassName, boolean dump) throws IOException {
        String messageOut;
        String messageIn;
        Class callerClass = EJCTestUtil.getCallerClass();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = null;
        Object factoryInstance = null;
        try {
            factoryClass = classLoader.loadClass("org.smooks.ejc.test." + factoryClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception loading model Factory class: " + e.getMessage());
        }
        try {
            factoryInstance = factoryClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception creating Factory class instance: " + e.getMessage());
        }
        String ediMessage = StreamUtils.readStreamAsString((InputStream)callerClass.getResourceAsStream(ediMessageFile));
        Object modelInstance = null;
        try {
            modelInstance = EJCTestUtil.findFromEDIMethod(factoryClass).invoke(factoryInstance, new StringReader(ediMessage));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception invoking 'fromEDI' method on Factory class instance: " + e.getMessage());
        }
        StringWriter ediOut = new StringWriter();
        try {
            EJCTestUtil.findToEDIMethod(factoryClass).invoke(factoryInstance, modelInstance, ediOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception invoking 'fromEDI' method on Factory class instance: " + e.getMessage());
        }
        if (dump) {
            System.out.println("\n==== Serialized EDI Model ====");
            System.out.println(ediOut.toString());
            System.out.println("==============================\n");
        }
        if (!(messageIn = StreamUtils.normalizeLines((String)ediMessage, (boolean)false).trim()).equals(messageOut = ediOut.toString().trim())) {
            throw new IllegalStateException("Message in: \n" + messageIn + "\n is not equal to message out \n" + messageOut);
        }
    }

    private static Class getCallerClass() {
        StackTraceElement[] thisStack = Thread.currentThread().getStackTrace();
        Class<?> callerClass = null;
        for (int i = 0; i < thisStack.length; ++i) {
            String callingClass;
            if (!thisStack[i].getClassName().equals(EJCTestUtil.class.getName()) || (callingClass = thisStack[i + 1].getClassName()).equals(EJCTestUtil.class.getName())) continue;
            try {
                callerClass = Class.forName(callingClass);
                break;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new IllegalStateException("Exception resolving caller class: " + e.getMessage());
            }
        }
        return callerClass;
    }

    private static Method findFromEDIMethod(Class factoryClass) throws NoSuchMethodException {
        return factoryClass.getMethod("fromEDINR", Reader.class);
    }

    private static Method findToEDIMethod(Class factoryClass) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = factoryClass.getDeclaredMethods()) {
            if (!method.getName().equals("toEDI")) continue;
            return method;
        }
        throw new NoSuchMethodException("Failed to find 'toEDI' method on factory class '" + factoryClass.getName() + "'.");
    }
}

