/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.transform.Result;
import org.milyn.edi.test.MessageBuilder;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.io.StreamUtils;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchange;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchangeFactory;
import org.milyn.smooks.edi.unedifact.model.r41.UNB41;
import org.milyn.smooks.edi.unedifact.model.r41.UNEdifactInterchange41;
import org.milyn.smooks.edi.unedifact.model.r41.UNEdifactMessage41;
import org.milyn.smooks.edi.unedifact.model.r41.types.MessageIdentifier;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterchangeTestUtil {
    private static MessageBuilder defaultUNAMessageBuilder = new MessageBuilder("org.milyn", UNEdifactInterchangeParser.defaultUNEdifactDelimiters.getField(), UNEdifactInterchangeParser.defaultUNEdifactDelimiters);
    private static MessageBuilder commaDecimalSepUNAMessageBuilder = new MessageBuilder("org.milyn", UNEdifactInterchangeParser.defaultUNEdifactDelimiters.getField(), UNEdifactInterchangeParser.defaultUNEdifactDelimiters);

    public static void testJavaBinding(UNEdifactInterchangeFactory factory, String messageInFile, boolean dumpResult) throws IOException, SAXException {
        InputStream ediStream = InterchangeTestUtil.class.getResourceAsStream(messageInFile);
        if (ediStream == null) {
            throw new IOException("EDI input file '" + messageInFile + "' not on classpath.");
        }
        UNEdifactInterchange interchange = factory.fromUNEdifact(ediStream, new Result[0]);
        StringWriter writer = new StringWriter();
        factory.toUNEdifact(interchange, (Writer)writer);
        if (dumpResult) {
            System.out.println(writer.toString());
        }
        String expected = StreamUtils.readStreamAsString((InputStream)InterchangeTestUtil.class.getResourceAsStream(messageInFile));
        InterchangeTestUtil.assertEquals(expected, writer.toString());
    }

    public static void test_Interchange(UNEdifactInterchangeFactory factory, boolean dump, Class<?> ... messageTypes) throws IOException {
        UNEdifactInterchange41 interchange41 = InterchangeTestUtil.buildInterchange(messageTypes);
        InterchangeTestUtil.test_Interchange(factory, dump, interchange41);
    }

    public static void test_Interchange_Comma_Decimal(UNEdifactInterchangeFactory factory, boolean dump, Class<?> ... messageTypes) throws IOException {
        UNEdifactInterchange41 interchange41 = InterchangeTestUtil.buildInterchange(commaDecimalSepUNAMessageBuilder, messageTypes);
        InterchangeTestUtil.test_Interchange(factory, dump, interchange41);
    }

    public static void test_Interchange(UNEdifactInterchangeFactory factory, boolean dump, UNEdifactInterchange41 interchange41) throws IOException {
        StringWriter writer = new StringWriter();
        factory.toUNEdifact((UNEdifactInterchange)interchange41, (Writer)writer);
        String messageV1 = writer.toString();
        interchange41 = (UNEdifactInterchange41)factory.fromUNEdifact(new InputSource(new ByteArrayInputStream(messageV1.getBytes("UTF-8"))), new Result[0]);
        writer.getBuffer().setLength(0);
        factory.toUNEdifact((UNEdifactInterchange)interchange41, (Writer)writer);
        String messageV2 = writer.toString();
        InterchangeTestUtil.assertEquals(messageV1, messageV2);
        if (dump) {
            System.out.println(messageV1);
        }
    }

    public static UNEdifactInterchange41 buildInterchange(Class<?> ... messageTypes) {
        return InterchangeTestUtil.buildInterchange(defaultUNAMessageBuilder, messageTypes);
    }

    public static UNEdifactInterchange41 buildInterchange(MessageBuilder builder, Class<?> ... messageTypes) {
        return InterchangeTestUtil.buildInterchange("D", "03B", messageTypes, builder);
    }

    public static UNEdifactInterchange41 buildInterchange(String versionNum, String releaseNum, Class<?>[] messageTypes, MessageBuilder messageBuilder) {
        UNEdifactInterchange41 interchange41 = messageBuilder.buildMessage(UNEdifactInterchange41.class);
        UNB41 unb = interchange41.getInterchangeHeader();
        List messages = interchange41.getMessages();
        interchange41.setInterchangeDelimiters(messageBuilder.getDelimiters());
        unb.getSyntaxIdentifier().setId("UNOW");
        unb.getSyntaxIdentifier().setCodedCharacterEncoding("UNOW");
        messages.clear();
        for (Class<?> messageType : messageTypes) {
            UNEdifactMessage41 message41 = messageBuilder.buildMessage(UNEdifactMessage41.class);
            Object messageInstance = messageBuilder.buildMessage(messageType);
            MessageIdentifier messageIdentifier = message41.getMessageHeader().getMessageIdentifier();
            messageIdentifier.setControllingAgencyCode("UN");
            messageIdentifier.setId(messageType.getSimpleName().toUpperCase());
            messageIdentifier.setVersionNum(versionNum);
            messageIdentifier.setReleaseNum(releaseNum);
            message41.setMessage(messageInstance);
            messages.add(message41);
        }
        return interchange41;
    }

    private static void assertEquals(String expected, String actual) throws IOException {
        if (!(expected = StreamUtils.normalizeLines((String)expected, (boolean)false)).equals(actual = StreamUtils.normalizeLines((String)actual, (boolean)false))) {
            throw new IllegalStateException("Expected message \n" + expected + "\n not equal to actual message \n" + actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test_loads(UNEdifactInterchangeFactory factory, boolean dump, String ejcClassListFile, int numMessages) throws IOException, ClassNotFoundException {
        InputStream stream = InterchangeTestUtil.class.getResourceAsStream(ejcClassListFile);
        if (stream == null) {
            throw new IllegalStateException("Unable to load EJC list file '" + ejcClassListFile + "' from classpath.");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String ejcClassName = reader.readLine();
            int i = 1;
            long start = System.currentTimeMillis();
            while (ejcClassName != null) {
                InterchangeTestUtil.test_Interchange(factory, dump, Class.forName(ejcClassName));
                ejcClassName = reader.readLine();
                if (i == numMessages) break;
                ++i;
            }
            System.out.println("Took: " + (System.currentTimeMillis() - start));
        }
        finally {
            stream.close();
        }
    }

    static {
        Delimiters delimiters = ((Delimiters)UNEdifactInterchangeParser.defaultUNEdifactDelimiters.clone()).setDecimalSeparator(",");
        commaDecimalSepUNAMessageBuilder = new MessageBuilder("org.milyn", delimiters.getField(), delimiters);
    }
}

