/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.util.IteratorIterable;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDISchemaEntityManager
extends XMLEntityManager {
    private final Map<String, String> catalog;
    private static final Log log = LogFactory.getLog(EDISchemaEntityManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EDISchemaEntityManager createInstance() throws IOException {
        List urnFiles = ClassUtil.getResources((String)"/fragment.xml", EDISchemaEntityManager.class);
        HashMap<String, String> catalog = new HashMap<String, String>();
        log.debug((Object)("Loading XML schemas information from " + urnFiles));
        for (URL url : urnFiles) {
            InputStream in = url.openStream();
            try {
                if (in == null) continue;
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(in);
                IteratorIterable it = document.getDescendants((Filter)new ElementFilter("uri"));
                while (it.hasNext()) {
                    Element next = (Element)it.next();
                    String uri = next.getAttributeValue("uri");
                    String name = next.getAttributeValue("name");
                    uri = uri.substring(19);
                    uri = uri.substring(uri.indexOf(47));
                    catalog.put(name, uri);
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        catalog.put("urn:org.milyn.edi.unedifact.v41", "/META-INF/schema/v41-segments.xsd");
        log.debug((Object)("Loaded " + catalog.size() + " entries"));
        return new EDISchemaEntityManager(catalog);
    }

    protected EDISchemaEntityManager(Map<String, String> catalog) {
        this.catalog = catalog;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        String ns;
        XMLInputSource result = super.resolveEntity(resourceIdentifier);
        if (result.getPublicId() == null && result.getSystemId() == null && result.getCharacterStream() == null && result.getByteStream() == null && (ns = resourceIdentifier.getNamespace()) != null) {
            log.debug((Object)("Resolving schema to namespace: " + ns));
            if (this.catalog.containsKey(ns)) {
                result = new XMLInputSource(resourceIdentifier);
                String location = this.catalog.get(ns);
                InputStream stream = EDISchemaEntityManager.class.getResourceAsStream(location);
                if (stream == null) {
                    throw new XNIException("Smooks Entity Manager was unable to find resource with location: " + location);
                }
                result.setByteStream(stream);
            } else {
                throw new XNIException("Can't find schema with NS: " + ns);
            }
        }
        return result;
    }
}

