/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.milyn.ejc.EJCLogFactory;
import org.milyn.ejc.ValueNodeInfo;
import org.milyn.javabean.pojogen.JClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassModel {
    private static Log LOG = EJCLogFactory.getLog(ClassModel.class);
    private JClass root;
    private Map<String, JClass> createdClasses;
    private Map<String, ValueNodeInfo> valueNodeInfos;

    public JClass getRoot() {
        return this.root;
    }

    public void setRoot(JClass root) {
        this.root = root;
    }

    public Map<String, JClass> getCreatedClasses() {
        if (this.createdClasses == null) {
            this.createdClasses = new HashMap<String, JClass>();
        }
        return this.createdClasses;
    }

    public void addClass(JClass jclass) {
        this.getCreatedClasses().put(jclass.getClassName(), jclass);
        LOG.info((Object)("Added class " + jclass.getPackageName() + "." + jclass.getClassName() + " to model."));
    }

    public void addClassValueNodeConfig(JClass jclass, ValueNodeInfo valueNodeInfo) {
        this.getValueNodeInfos().put(jclass.getClassName(), valueNodeInfo);
    }

    public void addPropertyValueNodeConfig(String className, String propertyName, ValueNodeInfo valueNodeInfo) {
        this.getValueNodeInfos().put(className + "." + propertyName, valueNodeInfo);
    }

    public String getClassXmlElementName(String className) {
        return this.getValueNodeInfos().get(className).getXmlElementName();
    }

    public String getPropertyXmlElementName(String className, String propertyName) {
        return this.getValueNodeInfos().get(className + "." + propertyName).getXmlElementName();
    }

    public List<Map.Entry<String, String>> getPropertyDecoderConfigs(String className, String propertyName) {
        return this.getValueNodeInfos().get(className + "." + propertyName).getDecoderConfigs();
    }

    private Map<String, ValueNodeInfo> getValueNodeInfos() {
        if (this.valueNodeInfos == null) {
            this.valueNodeInfos = new HashMap<String, ValueNodeInfo>();
        }
        return this.valueNodeInfos;
    }
}

