/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.milyn.ejc.EJC;
import org.milyn.ejc.EJCException;

public class EJCExecutor {
    private File ediMappingModel;
    private File destDir;
    private String packageName;

    public void execute() throws EJCException {
        FileInputStream configInputStream;
        this.assertMandatoryProperty(this.ediMappingModel, "ediMappingModel");
        this.assertMandatoryProperty(this.destDir, "destDir");
        this.assertMandatoryProperty(this.packageName, "packageName");
        if (!this.ediMappingModel.exists()) {
            throw new EJCException("Specified EDI Mapping Model file '" + this.ediMappingModel.getAbsoluteFile() + "' does not exist.");
        }
        if (this.ediMappingModel.exists() && this.ediMappingModel.isDirectory()) {
            throw new EJCException("Specified EDI Mapping Model file '" + this.ediMappingModel.getAbsoluteFile() + "' exists, but is a directory.  Must be an EDI Mapping Model file.");
        }
        if (this.destDir.exists() && !this.destDir.isDirectory()) {
            throw new EJCException("Specified EJC destination directory '" + this.destDir.getAbsoluteFile() + "' exists, but is not a directory.");
        }
        EJC ejc = new EJC();
        try {
            configInputStream = new FileInputStream(this.ediMappingModel);
        }
        catch (FileNotFoundException e) {
            throw new EJCException("Error opening EDI Mapping Model InputStream '" + this.ediMappingModel.getAbsoluteFile() + "'.", e);
        }
        try {
            ejc.compile(configInputStream, this.ediMappingModel.getAbsolutePath(), this.packageName, this.destDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new EJCException("Error compiling EDI Mapping Model '" + this.ediMappingModel.getAbsoluteFile() + "'.", e);
        }
        finally {
            try {
                configInputStream.close();
            }
            catch (IOException e) {
                throw new EJCException("Error closing EDI Mapping Model '" + this.ediMappingModel.getAbsoluteFile() + "'.", e);
            }
        }
    }

    public void setEdiMappingModel(File ediMappingModel) {
        this.ediMappingModel = ediMappingModel;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void assertMandatoryProperty(Object obj, String name) {
        if (obj == null) {
            throw new EJCException("Mandatory EJC property '" + name + "' + not specified.");
        }
    }
}

