/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.List;
import org.apache.commons.logging.Log;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.model.internal.ValueNode;
import org.milyn.ejc.ClassModel;
import org.milyn.ejc.EJCLogFactory;
import org.milyn.ejc.EJCUtils;
import org.milyn.ejc.IllegalNameException;
import org.milyn.ejc.ValueNodeInfo;
import org.milyn.javabean.pojogen.JClass;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdiConfigReader {
    private static Log LOG = EJCLogFactory.getLog(EdiConfigReader.class);
    private ClassModel model;

    public ClassModel parse(Edimap edimap, String classPackage) throws IllegalNameException {
        this.model = new ClassModel();
        SegmentGroup segmentGroup = edimap.getSegments();
        JClass rootClass = new JClass(classPackage, EJCUtils.encodeClassName(segmentGroup.getXmltag()));
        this.model.addClass(rootClass);
        this.model.addClassValueNodeConfig(rootClass, new ValueNodeInfo(segmentGroup.getXmltag(), null));
        this.model.setRoot(rootClass);
        LOG.debug((Object)("Added root class [" + rootClass + "] to ClassModel."));
        this.parseSegmentGroups(segmentGroup.getSegments(), rootClass);
        LOG.debug((Object)"Finished parsing edi-configuration. All segments are added to ClassModel.");
        LOG.debug((Object)("ClassModel contains " + this.model.getCreatedClasses().size() + " classes."));
        return this.model;
    }

    private void parseSegmentGroups(List<SegmentGroup> segmentGroups, JClass parent) throws IllegalNameException {
        for (SegmentGroup segmentGroup : segmentGroups) {
            this.parseSegmentGroup(segmentGroup, parent);
        }
    }

    private void parseSegmentGroup(SegmentGroup segmentGroup, JClass parent) throws IllegalNameException {
        LOG.debug((Object)("Parsing SegmentGroup " + segmentGroup.getXmltag()));
        JClass child = this.createChildAndConnectWithParent(parent, (MappingNode)segmentGroup, segmentGroup.getMaxOccurs());
        if (segmentGroup instanceof Segment) {
            this.parseFields(((Segment)segmentGroup).getFields(), child);
        }
        this.parseSegmentGroups(segmentGroup.getSegments(), child);
    }

    private void parseFields(List<Field> fields, JClass parent) throws IllegalNameException {
        for (Field field : fields) {
            LOG.debug((Object)("Parsing field " + field.getXmltag()));
            if (field.getComponent() != null && field.getComponent().size() > 0) {
                JClass child = this.createChildAndConnectWithParent(parent, (MappingNode)field, 1);
                this.parseComponents(field.getComponent(), child);
                continue;
            }
            this.createAndAddSimpleType((ValueNode)field, parent);
        }
    }

    private void createAndAddSimpleType(ValueNode valueNode, JClass parent) throws IllegalNameException {
        JType jtype = valueNode.getType() != null && !valueNode.getType().equals("") ? new JType(valueNode.getTypeClass()) : new JType(String.class);
        String propertyName = EJCUtils.encodeAttributeName(jtype, valueNode.getXmltag());
        parent.addProperty(new JNamedType(jtype, propertyName));
        this.model.addPropertyValueNodeConfig(parent.getClassName(), propertyName, new ValueNodeInfo(valueNode.getXmltag(), valueNode.getTypeParameters()));
    }

    private void parseComponents(List<Component> components, JClass parent) throws IllegalNameException {
        for (Component component : components) {
            if (component.getSubComponent() != null && component.getSubComponent().size() > 0) {
                JClass child = this.createChildAndConnectWithParent(parent, (MappingNode)component, 1);
                this.parseSubComponents(component.getSubComponent(), child);
                continue;
            }
            this.createAndAddSimpleType((ValueNode)component, parent);
        }
    }

    private void parseSubComponents(List<SubComponent> subComponents, JClass parent) throws IllegalNameException {
        for (SubComponent subComponent : subComponents) {
            this.createAndAddSimpleType((ValueNode)subComponent, parent);
        }
    }

    private JClass createChildAndConnectWithParent(JClass parent, MappingNode mappingNode, int maxOccurs) throws IllegalNameException {
        JClass child = new JClass(parent.getPackageName(), EJCUtils.encodeClassName(mappingNode.getXmltag()));
        LOG.debug((Object)("Created class " + child.getClassName() + "."));
        JType jtype = maxOccurs > 1 || maxOccurs == -1 ? new JType(List.class, child.getSkeletonClass()) : new JType(child.getSkeletonClass());
        String propertyName = EJCUtils.encodeAttributeName(jtype, mappingNode.getXmltag());
        parent.addProperty(new JNamedType(jtype, propertyName));
        this.model.addClass(child);
        this.model.addClassValueNodeConfig(child, new ValueNodeInfo(mappingNode.getXmltag(), null));
        this.model.addPropertyValueNodeConfig(child.getClassName(), propertyName, new ValueNodeInfo(mappingNode.getXmltag(), null));
        return child;
    }
}

